/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.access;

import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.access.LoginHistoryDAO;
import nl.strohalm.cyclos.entities.access.LoginHistoryLog;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.reports.StatisticalDTO;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.Pair;
import org.apache.commons.collections.CollectionUtils;

public class LoginHistoryDAOImpl
extends BaseDAOImpl<LoginHistoryLog>
implements LoginHistoryDAO {
    public LoginHistoryDAOImpl() {
        super(LoginHistoryLog.class);
    }

    @Override
    public Calendar getFirstLoginHistoryDate() {
        String hql = "select min(lh.date) from LoginHistoryLog as lh";
        return (Calendar)this.uniqueResult("select min(lh.date) from LoginHistoryLog as lh", new HashMap());
    }

    @Override
    public List<Pair<User, Number>> list(StatisticalDTO dto) throws DaoException, EntityNotFoundException {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder();
        hql.append(" select new " + Pair.class.getName() + "(mu, count(lhl.id)) ");
        hql.append(" from MemberUser mu ");
        hql.append(" join mu.element m ");
        hql.append(" left join mu.loginHistory lhl ");
        hql.append(" where 1=1 ");
        Calendar begin = dto.getPeriod().getBegin();
        Calendar end = dto.getPeriod().getEnd();
        if (dto.getPeriod().isUseTime()) {
            if (end != null) {
                end = (Calendar)end.clone();
                end.add(13, 1);
            }
        } else {
            begin = DateHelper.truncate(begin);
            end = DateHelper.truncateNextDay(end);
        }
        namedParameters.put("begin", begin);
        namedParameters.put("end", end);
        hql.append("and (lhl.date is null or (lhl.date >= :begin and lhl.date < :end))");
        if (!CollectionUtils.isEmpty(dto.getGroups())) {
            hql.append(" and exists ");
            hql.append(" ( ");
            hql.append("    select ghl.id from GroupHistoryLog ghl ");
            hql.append("    where ghl.element.id = m.id ");
            hql.append("    and ghl.group in (:groups) ");
            hql.append("    and ghl.period.begin < :end ");
            hql.append("    and (ghl.period.end is null or ghl.period.end >= :begin) ");
            hql.append("    and (lhl.date is null or lhl.date between ghl.period.begin and ifnull(ghl.period.end, lhl.date)) ");
            hql.append(" ) ");
            namedParameters.put("groups", dto.getGroups());
        }
        hql.append(" group by mu ");
        hql.append(" order by count(lhl.id) desc ");
        List<Pair<User, Number>> logs = this.list(hql.toString(), namedParameters);
        return logs;
    }
}

