/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.access;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.access.SessionDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Session;
import nl.strohalm.cyclos.entities.access.SessionQuery;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.utils.IteratorListImpl;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import nl.strohalm.cyclos.utils.query.IteratorList;
import nl.strohalm.cyclos.utils.query.PageParameters;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import org.apache.commons.collections.CollectionUtils;

public class SessionDAOImpl
extends BaseDAOImpl<Session>
implements SessionDAO {
    public SessionDAOImpl() {
        super(Session.class);
    }

    @Override
    public int delete(User user) {
        Map<String, User> params = Collections.singletonMap("user", user);
        return this.bulkUpdate("delete from Session where user = :user", params);
    }

    @Override
    public boolean isLoggedIn(User user) {
        Map<String, User> params = Collections.singletonMap("user", user);
        List list = this.list(QueryParameters.ResultType.LIST, "select s.id from Session s where s.user = :user and s.expirationDate > now()", params, PageParameters.max(1), new Relationship[0]);
        return !list.isEmpty();
    }

    @Override
    public IteratorList<User> listLoggedUsers() {
        Iterator iterator = this.iterate("select distinct s.user from Session s where s.expirationDate > now()", null);
        return new IteratorListImpl<User>(iterator);
    }

    @Override
    public Session load(String sessionId, boolean allowExpired) throws EntityNotFoundException {
        Session session;
        Map<String, String> params = Collections.singletonMap("identifier", sessionId);
        StringBuilder hql = new StringBuilder();
        hql.append(" select s");
        hql.append(" from Session s");
        hql.append("   left join fetch s.user u");
        hql.append("   left join fetch u.element e");
        hql.append("   left join fetch e.group g");
        hql.append("   left join fetch e.member m");
        hql.append("   left join fetch m.group mg");
        hql.append(" where s.identifier = :identifier");
        if (!allowExpired) {
            hql.append(" and s.expirationDate > now()");
        }
        if ((session = (Session)this.uniqueResult(hql.toString(), params)) == null) {
            throw new EntityNotFoundException();
        }
        return session;
    }

    @Override
    public void purgeExpired() {
        this.bulkUpdate("delete from Session where expirationDate <= now()", null);
    }

    @Override
    public List<Session> search(SessionQuery query) {
        boolean hasOperator;
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder();
        hql.append(" select s ");
        hql.append(" from Session s left join fetch s.user u left join fetch u.element e left join fetch e.group g ");
        hql.append(" where s.expirationDate > now() ");
        Collection<Group.Nature> natures = query.getNatures();
        if (CollectionUtils.isNotEmpty(natures)) {
            ArrayList<String> values = new ArrayList<String>(natures.size());
            for (Group.Nature nature : natures) {
                values.add(nature.getDiscriminator());
            }
            HibernateHelper.addInParameterToQuery(hql, params, "s.user.element.group.class", values);
        }
        boolean bl = hasOperator = CollectionUtils.isEmpty(natures) || natures.contains((Object)Group.Nature.OPERATOR);
        if (hasOperator) {
            hql.append("and (s.user.element.group in (:groups) or exists (");
            hql.append("    select o.id");
            hql.append("    from Operator o");
            hql.append("    where o = s.user.element");
            hql.append("      and o.member.group in (:groups)");
            hql.append("))");
            params.put("groups", query.getGroups());
        } else {
            HibernateHelper.addInParameterToQuery(hql, params, "s.user.element.group", query.getGroups());
        }
        if (query.getMember() != null) {
            hql.append("and exists (");
            hql.append("    select o.id");
            hql.append("    from Operator o");
            hql.append("    where o = s.user.element");
            hql.append("      and o.member = :member");
            hql.append(")");
            params.put("member", query.getMember());
        }
        HibernateHelper.appendOrder(hql, "s.user.element.name");
        return this.list(query, hql.toString(), params);
    }

    @Override
    public void updateExpiration(Long id, Calendar newExpiration) {
        HashMap<String, Comparable<Long>> params = new HashMap<String, Comparable<Long>>();
        params.put("id", id);
        params.put("newExpiration", newExpiration);
        this.bulkUpdate("update Session set expirationDate = :newExpiration where id = :id and expirationDate < :newExpiration", params);
    }
}

