/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.access;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.access.UserDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.OperatorUser;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import nl.strohalm.cyclos.utils.query.PageParameters;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class UserDAOImpl
extends BaseDAOImpl<User>
implements UserDAO {
    public UserDAOImpl() {
        super(User.class);
    }

    @Override
    public <T extends User> T load(String username, Relationship ... fetch) throws EntityNotFoundException, DaoException {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        namedParameters.put("username", username);
        namedParameters.put("admin", Element.Nature.ADMIN.getValue());
        namedParameters.put("member", Element.Nature.MEMBER.getValue());
        namedParameters.put("removed", Group.Status.REMOVED);
        User user = (User)this.uniqueResult("select u from User u left join fetch u.element e where u.username = :username and e.class in (:admin, :member) and e.group.status <> :removed", namedParameters);
        if (user == null) {
            throw new EntityNotFoundException(this.getEntityType());
        }
        return (T)this.getFetchDao().fetch(user, fetch);
    }

    @Override
    public OperatorUser loadOperator(Member member, String username, Relationship ... fetch) throws EntityNotFoundException, DaoException {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder();
        hql.append("select u from OperatorUser u, Operator o ");
        HibernateHelper.appendJoinFetch(hql, OperatorUser.class, "u", Arrays.asList(fetch));
        hql.append(" where u.id = o.id");
        HibernateHelper.addParameterToQuery(hql, namedParameters, "o.member", member);
        HibernateHelper.addParameterToQuery(hql, namedParameters, "u.username", username);
        List list = this.list(QueryParameters.ResultType.LIST, hql.toString(), namedParameters, PageParameters.unique(), fetch);
        if (list.isEmpty()) {
            throw new EntityNotFoundException(OperatorUser.class);
        }
        return (OperatorUser)list.iterator().next();
    }
}

