/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.access;

import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.access.WrongCredentialAttemptsDAO;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.access.WrongCredentialAttempt;
import nl.strohalm.cyclos.entities.accounts.cards.Card;
import nl.strohalm.cyclos.entities.accounts.pos.MemberPos;

public class WrongCredentialAttemptsDAOImpl
extends BaseDAOImpl<WrongCredentialAttempt>
implements WrongCredentialAttemptsDAO {
    public WrongCredentialAttemptsDAOImpl() {
        super(WrongCredentialAttempt.class);
    }

    @Override
    public void clear(Calendar limit) {
        Map<String, Calendar> params = Collections.singletonMap("limit", limit);
        this.bulkUpdate("delete from WrongCredentialAttempt where date < :limit", params);
    }

    @Override
    public void clear(Card card) {
        Map<String, Card> params = Collections.singletonMap("card", card);
        this.bulkUpdate("delete from WrongCredentialAttempt where card = :card", params);
    }

    @Override
    public void clear(MemberPos memberPos) {
        Map<String, MemberPos> params = Collections.singletonMap("memberPos", memberPos);
        this.bulkUpdate("delete from WrongCredentialAttempt where memberPos = :memberPos", params);
    }

    @Override
    public void clear(User user, Channel.Credentials credentialType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("user", user);
        params.put("credentialType", credentialType);
        this.bulkUpdate("delete from WrongCredentialAttempt where user = :user and credentialType = :credentialType", params);
    }

    @Override
    public int count(Calendar limit, Card card) {
        HashMap<String, Cloneable> params = new HashMap<String, Cloneable>();
        params.put("limit", limit);
        params.put("card", card);
        return (Integer)this.uniqueResult("select count(*) from WrongCredentialAttempt a where a.date >= :limit and a.card = :card", params);
    }

    @Override
    public int count(Calendar limit, MemberPos memberPos) {
        HashMap<String, Cloneable> params = new HashMap<String, Cloneable>();
        params.put("limit", limit);
        params.put("memberPos", memberPos);
        return (Integer)this.uniqueResult("select count(*) from WrongCredentialAttempt a where a.date >= :limit and a.memberPos = :memberPos", params);
    }

    @Override
    public int count(Calendar limit, User user, Channel.Credentials credentialType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("limit", limit);
        params.put("user", user);
        params.put("credentialType", credentialType);
        return (Integer)this.uniqueResult("select count(*) from WrongCredentialAttempt a where a.date >= :limit and a.user = :user and a.credentialType = :credentialType", params);
    }

    @Override
    public WrongCredentialAttempt record(Card card) {
        WrongCredentialAttempt attempt = new WrongCredentialAttempt();
        attempt.setDate(Calendar.getInstance());
        attempt.setCard(card);
        return this.insert(attempt);
    }

    @Override
    public WrongCredentialAttempt record(MemberPos memberPos) {
        WrongCredentialAttempt attempt = new WrongCredentialAttempt();
        attempt.setDate(Calendar.getInstance());
        attempt.setMemberPos(memberPos);
        return this.insert(attempt);
    }

    @Override
    public WrongCredentialAttempt record(User user, Channel.Credentials credentialType) {
        WrongCredentialAttempt attempt = new WrongCredentialAttempt();
        attempt.setDate(Calendar.getInstance());
        attempt.setUser(user);
        attempt.setCredentialType(credentialType);
        return this.insert(attempt);
    }
}

