/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.access;

import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.access.WrongUsernameAttemptsDAO;
import nl.strohalm.cyclos.entities.access.WrongUsernameAttempt;

public class WrongUsernameAttemptsDAOImpl
extends BaseDAOImpl<WrongUsernameAttempt>
implements WrongUsernameAttemptsDAO {
    public WrongUsernameAttemptsDAOImpl() {
        super(WrongUsernameAttempt.class);
    }

    @Override
    public void clear(Calendar limit) {
        Map<String, Calendar> params = Collections.singletonMap("limit", limit);
        this.bulkUpdate("delete from WrongUsernameAttempt where date < :limit", params);
    }

    @Override
    public void clear(String remoteAddress) {
        Map<String, String> params = Collections.singletonMap("remoteAddress", remoteAddress);
        this.bulkUpdate("delete from WrongUsernameAttempt where remoteAddress = :remoteAddress", params);
    }

    @Override
    public int count(Calendar limit, String remoteAddress) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("limit", limit);
        params.put("remoteAddress", remoteAddress);
        return (Integer)this.uniqueResult("select count(*) from WrongUsernameAttempt a where a.date >= :limit and a.remoteAddress = :remoteAddress", params);
    }

    @Override
    public WrongUsernameAttempt record(String remoteAddress) {
        WrongUsernameAttempt attempt = new WrongUsernameAttempt();
        attempt.setDate(Calendar.getInstance());
        attempt.setRemoteAddress(remoteAddress);
        return this.insert(attempt);
    }
}

