/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.accounts;

import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import nl.strohalm.cyclos.dao.BaseDAO;
import nl.strohalm.cyclos.dao.DeletableDAO;
import nl.strohalm.cyclos.dao.InsertableDAO;
import nl.strohalm.cyclos.dao.UpdatableDAO;
import nl.strohalm.cyclos.dao.accounts.AccountDailyDifference;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountQuery;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.MemberTransactionDetailsReportData;
import nl.strohalm.cyclos.entities.members.MemberTransactionSummaryVO;
import nl.strohalm.cyclos.entities.members.MembersTransactionsReportParameters;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.accounts.AccountDTO;
import nl.strohalm.cyclos.services.accounts.BulkUpdateAccountDTO;
import nl.strohalm.cyclos.services.accounts.GetTransactionsDTO;
import nl.strohalm.cyclos.services.transactions.TransactionSummaryVO;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.query.IteratorList;

public interface AccountDAO
extends BaseDAO<Account>,
InsertableDAO<Account>,
UpdatableDAO<Account>,
DeletableDAO<Account> {
    public void bulkUpdateCreditLimites(BulkUpdateAccountDTO var1);

    public int countAccounts(MemberGroup var1, MemberAccountType var2, MemberAccount.Action var3);

    public TransactionSummaryVO getBrokerCommissions(GetTransactionsDTO var1) throws EntityNotFoundException, DaoException;

    public TransactionSummaryVO getCredits(GetTransactionsDTO var1) throws EntityNotFoundException, DaoException;

    public TransactionSummaryVO getDebits(GetTransactionsDTO var1) throws EntityNotFoundException, DaoException;

    public TransactionSummaryVO getLoans(GetTransactionsDTO var1) throws EntityNotFoundException, DaoException;

    public MemberAccount getNextPendingProcessing();

    public TransactionSummaryVO getPendingCredits(GetTransactionsDTO var1) throws EntityNotFoundException, DaoException;

    public TransactionSummaryVO getPendingDebits(GetTransactionsDTO var1) throws EntityNotFoundException, DaoException;

    public IteratorList<AccountDailyDifference> iterateDailyDifferences(MemberAccount var1, Period var2);

    public IteratorList<Account> iterateUnclosedAccounts(Calendar var1, int var2);

    public Account load(AccountOwner var1, AccountType var2, Relationship ... var3) throws EntityNotFoundException, DaoException;

    public List<Account> loadAll(List<AccountDTO> var1, Relationship ... var2) throws EntityNotFoundException, DaoException;

    public void markForActivation(BulkUpdateAccountDTO var1);

    public void markForDeactivation(MemberAccountType var1, MemberGroup var2);

    public Iterator<MemberTransactionDetailsReportData> membersTransactionsDetailsReport(MembersTransactionsReportParameters var1);

    public Iterator<MemberTransactionSummaryVO> membersTransactionSummaryReport(Collection<MemberGroup> var1, PaymentFilter var2, Period var3, boolean var4, LocalSettings.MemberResultDisplay var5);

    public List<? extends Account> search(AccountQuery var1) throws DaoException;
}

