/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.accounts;

import java.io.Closeable;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.JDBCCallback;
import nl.strohalm.cyclos.dao.accounts.AccountDAO;
import nl.strohalm.cyclos.dao.accounts.AccountDailyDifference;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountLock;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountQuery;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.SystemAccount;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.BrokerCommission;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.MemberTransactionDetailsReportData;
import nl.strohalm.cyclos.entities.members.MemberTransactionSummaryVO;
import nl.strohalm.cyclos.entities.members.MembersTransactionsReportParameters;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.accounts.AccountDTO;
import nl.strohalm.cyclos.services.accounts.BulkUpdateAccountDTO;
import nl.strohalm.cyclos.services.accounts.GetTransactionsDTO;
import nl.strohalm.cyclos.services.transactions.TransactionSummaryVO;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.IteratorListImpl;
import nl.strohalm.cyclos.utils.JDBCWrapper;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.PropertyHelper;
import nl.strohalm.cyclos.utils.ScrollableResultsIterator;
import nl.strohalm.cyclos.utils.conversion.Transformer;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import nl.strohalm.cyclos.utils.query.IteratorList;
import nl.strohalm.cyclos.utils.query.PageParameters;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class AccountDAOImpl
extends BaseDAOImpl<Account>
implements AccountDAO {
    private static final char[] COLUMN_DELIMITERS = new char[]{'_'};

    public AccountDAOImpl() {
        super(Account.class);
    }

    @Override
    public void bulkUpdateCreditLimites(BulkUpdateAccountDTO dto) {
        HashMap<String, Comparable<BigDecimal>> namedParameters = new HashMap<String, Comparable<BigDecimal>>();
        StringBuilder hql = new StringBuilder();
        hql.append("update MemberAccount ma set ");
        hql.append(" ma.creditLimit = :limit, ");
        namedParameters.put("limit", dto.getCreditLimit());
        hql.append(" ma.upperCreditLimit = :upperLimit ");
        namedParameters.put("upperLimit", dto.getUpperCreditLimit());
        hql.append(" where ma.type = :type ");
        namedParameters.put("type", dto.getType());
        hql.append(" and ma.member in ");
        hql.append("      (from Member m where 1 = 1 ");
        hql.append("       and m.group = :group ) ");
        namedParameters.put("group", dto.getGroup());
        this.bulkUpdate(hql.toString(), namedParameters);
    }

    @Override
    public int countAccounts(MemberGroup group, MemberAccountType accountType, MemberAccount.Action action) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group", group);
        params.put("type", accountType);
        params.put("action", action);
        StringBuilder hql = new StringBuilder();
        hql.append(" select count(*) ");
        hql.append(" from MemberAccount ma");
        hql.append(" where ma.member.group = :group ");
        hql.append(" and ma.type = :type ");
        hql.append(" and ma.action = :action ");
        return (Integer)this.uniqueResult(hql.toString(), params);
    }

    @Override
    public int delete(boolean flush, Long ... ids) {
        this.getSession().createQuery("delete from AccountLock l where l.id in (:ids)").setParameterList("ids", (Object[])ids).executeUpdate();
        return super.delete(flush, ids);
    }

    @Override
    public TransactionSummaryVO getBrokerCommissions(GetTransactionsDTO dto) throws EntityNotFoundException, DaoException {
        PaymentFilter paymentFilter;
        Account account = this.load(dto.getOwner(), dto.getType(), new Relationship[0]);
        Period period = dto.getPeriod();
        StringBuilder hql = new StringBuilder();
        HashMap<String, Object> namedParams = new HashMap<String, Object>();
        hql.append(" select count(*), sum(t.amount)");
        hql.append(" from " + Transfer.class.getName() + " t, " + BrokerCommission.class.getName() + " f");
        hql.append(" where t.accountFeeLog.accountFee = f ");
        Collection<PaymentFilter> paymentFilters = dto.getPaymentFilters();
        if (CollectionUtils.isNotEmpty(paymentFilters) && (paymentFilter = paymentFilters.iterator().next()) != null) {
            hql.append(" and t.type in (select pf.transferTypes from " + PaymentFilter.class.getName() + " pf where pf = :pf) ");
            namedParams.put("pf", paymentFilter);
        }
        hql.append("   and t.to = :account ");
        namedParams.put("account", account);
        HibernateHelper.addPeriodParameterToQuery(hql, namedParams, "ifnull(t.processDate, t.date)", period);
        return this.buildSummary(this.uniqueResult(hql.toString(), namedParams));
    }

    @Override
    public TransactionSummaryVO getCredits(GetTransactionsDTO dto) {
        return this.getSummary(dto, true, Payment.Status.PROCESSED);
    }

    @Override
    public TransactionSummaryVO getDebits(GetTransactionsDTO dto) {
        return this.getSummary(dto, false, Payment.Status.PROCESSED);
    }

    @Override
    public TransactionSummaryVO getLoans(GetTransactionsDTO dto) throws EntityNotFoundException, DaoException {
        PaymentFilter paymentFilter;
        Account account = this.load(dto.getOwner(), dto.getType(), new Relationship[0]);
        Period period = dto.getPeriod();
        StringBuilder hql = new StringBuilder();
        HashMap<String, Object> namedParams = new HashMap<String, Object>();
        hql.append(" select count(*), sum(t.amount)");
        hql.append(" from " + Loan.class.getName() + " l join l.transfer t");
        hql.append(" where t.to = :account ");
        Collection<PaymentFilter> paymentFilters = dto.getPaymentFilters();
        if (CollectionUtils.isNotEmpty(paymentFilters) && (paymentFilter = paymentFilters.iterator().next()) != null) {
            hql.append(" and t.type in (select pf.transferTypes from " + PaymentFilter.class.getName() + " pf where pf = :pf) ");
            namedParams.put("pf", paymentFilter);
        }
        namedParams.put("account", account);
        HibernateHelper.addPeriodParameterToQuery(hql, namedParams, "ifnull(t.processDate, t.date)", period);
        return this.buildSummary(this.uniqueResult(hql.toString(), namedParams));
    }

    @Override
    public MemberAccount getNextPendingProcessing() {
        StringBuilder hql = new StringBuilder();
        hql.append("from MemberAccount ");
        hql.append(" where action is not null");
        return (MemberAccount)this.uniqueResult(hql.toString(), null);
    }

    @Override
    public TransactionSummaryVO getPendingCredits(GetTransactionsDTO dto) throws EntityNotFoundException, DaoException {
        return this.getSummary(dto, true, Payment.Status.PENDING);
    }

    @Override
    public TransactionSummaryVO getPendingDebits(GetTransactionsDTO dto) throws EntityNotFoundException, DaoException {
        return this.getSummary(dto, false, Payment.Status.PENDING);
    }

    @Override
    public <T extends Account> T insert(T entity, boolean flush) throws UnexpectedEntityException, DaoException {
        T account = super.insert(entity, false);
        this.getSession().persist((Object)new AccountLock(account));
        if (flush) {
            this.getSession().flush();
        }
        return account;
    }

    @Override
    public IteratorList<AccountDailyDifference> iterateDailyDifferences(MemberAccount account, Period period) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountId", account.getId());
        HibernateHelper.QueryParameter beginParameter = HibernateHelper.getBeginParameter(period);
        HibernateHelper.QueryParameter endParameter = HibernateHelper.getEndParameter(period);
        if (beginParameter != null) {
            params.put("begin", beginParameter.getValue());
        }
        if (endParameter != null) {
            params.put("end", endParameter.getValue());
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" select type, date(d.date) as date, sum(amount) as amount ");
        sql.append(" from ( ");
        sql.append("     select 'B' as type, t.process_date as date, ");
        sql.append("         case when t.chargeback_of_id is null then ");
        sql.append("             case when t.from_account_id = :accountId then -t.amount else t.amount end ");
        sql.append("         else ");
        sql.append("             case when t.to_account_id = :accountId then t.amount else -t.amount end ");
        sql.append("         end as amount ");
        sql.append("      from transfers t ");
        sql.append("      where (t.from_account_id = :accountId or t.to_account_id = :accountId) ");
        sql.append("      and t.process_date is not null ");
        if (beginParameter != null) {
            sql.append("  and t.process_date " + beginParameter.getOperator() + " :begin");
        }
        if (endParameter != null) {
            sql.append("  and t.process_date " + endParameter.getOperator() + " :end");
        }
        sql.append("      union ");
        sql.append("      select 'R', r.date, r.amount ");
        sql.append("      from amount_reservations r ");
        sql.append("      where r.account_id = :accountId ");
        if (beginParameter != null) {
            sql.append("  and r.date " + beginParameter.getOperator() + " :begin");
        }
        if (endParameter != null) {
            sql.append("  and r.date " + endParameter.getOperator() + " :end");
        }
        sql.append(" ) d ");
        sql.append(" group by type, date(d.date) ");
        sql.append(" order by date(d.date) ");
        SQLQuery query = this.getSession().createSQLQuery(sql.toString());
        query.addScalar("type", (Type)StandardBasicTypes.STRING);
        query.addScalar("date", (Type)StandardBasicTypes.CALENDAR_DATE);
        query.addScalar("amount", (Type)StandardBasicTypes.BIG_DECIMAL);
        this.getHibernateQueryHandler().setQueryParameters((Query)query, params);
        ScrollableResults results = query.scroll(ScrollMode.SCROLL_INSENSITIVE);
        return new IteratorListImpl<AccountDailyDifference>(new DiffsIterator(results));
    }

    @Override
    public IteratorList<Account> iterateUnclosedAccounts(Calendar day, int maxResults) {
        Map<String, Calendar> params = Collections.singletonMap("day", day);
        StringBuilder hql = new StringBuilder();
        hql.append(" from Account a ");
        hql.append(" where (last_closing_date is null or last_closing_date < :day)");
        List accounts = this.list(QueryParameters.ResultType.ITERATOR, hql.toString(), params, PageParameters.max(maxResults), new Relationship[0]);
        return (IteratorList)accounts;
    }

    @Override
    public Account load(AccountOwner owner, AccountType type, Relationship ... fetch) throws EntityNotFoundException, DaoException {
        String hql;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", type);
        if (owner instanceof SystemAccountOwner) {
            hql = "from SystemAccount a where a.type = :type";
        } else if (owner instanceof Member) {
            hql = "from MemberAccount a where a.member = :member and a.type = :type";
            params.put("member", owner);
        } else {
            throw new EntityNotFoundException(Account.class);
        }
        Account account = (Account)this.uniqueResult(hql, params);
        if (account == null) {
            throw new EntityNotFoundException(Account.class);
        }
        return this.getFetchDao().fetch(account, fetch);
    }

    @Override
    public List<Account> loadAll(List<AccountDTO> dtos, Relationship ... fetch) throws EntityNotFoundException, DaoException {
        ArrayList<Account> accounts = new ArrayList<Account>();
        for (AccountDTO dto : dtos) {
            accounts.add(this.load(dto.getOwner(), dto.getType(), fetch));
        }
        return accounts;
    }

    @Override
    public void markForActivation(final BulkUpdateAccountDTO dto) {
        this.runNative(new JDBCCallback(){

            @Override
            public void execute(JDBCWrapper jdbc) throws SQLException {
                StringBuilder sql = new StringBuilder();
                Calendar date = Calendar.getInstance();
                Long typeId = dto.getType().getId();
                BigDecimal limit = dto.getCreditLimit();
                BigDecimal upperLimit = dto.getUpperCreditLimit();
                Long groupId = dto.getGroup().getId();
                if (jdbc.isHSQLDB()) {
                    sql.append("update accounts a");
                    sql.append(" set member_action = 'A'");
                    sql.append(" where a.member_status = 'I'");
                    sql.append("   and a.member_action is null");
                    sql.append("   and a.type_id = ?");
                    sql.append("   and exists (select 1 from members m");
                    sql.append("              where a.member_id = m.id and");
                    sql.append("              m.group_id = ?)");
                    jdbc.execute(sql.toString(), groupId, typeId);
                } else {
                    sql.append("update accounts a inner join members m on a.member_id = m.id");
                    sql.append(" set member_action = 'A'");
                    sql.append(" where a.member_status = 'I'");
                    sql.append("   and a.member_action is null");
                    sql.append("   and m.group_id = ?");
                    sql.append("   and a.type_id = ?");
                    jdbc.execute(sql.toString(), groupId, typeId);
                }
                sql.setLength(0);
                sql.append("insert into accounts ");
                sql.append("(subclass, creation_date, owner_name, type_id, credit_limit, ");
                sql.append(" upper_credit_limit, member_id, member_status, member_action) ");
                sql.append(" select ");
                sql.append(" 'M', ?, u.username, ?, ?, ?, m.id, 'I', 'A' ");
                sql.append(" from members m, users u ");
                sql.append(" where m.id = u.id and m.group_id = ? ");
                sql.append("   and not exists (");
                sql.append("       select 1");
                sql.append("       from accounts a");
                sql.append("       where a.member_id = m.id");
                sql.append("         and a.type_id = ?");
                sql.append("   )");
                jdbc.execute(sql.toString(), date, typeId, limit, upperLimit, groupId, typeId);
            }
        });
    }

    @Override
    public void markForDeactivation(MemberAccountType type, MemberGroup group) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder();
        hql.append("update MemberAccount ma set ");
        hql.append(" ma.action = :action ");
        namedParameters.put("action", MemberAccount.Action.REMOVE);
        hql.append(" where ma.type = :type ");
        namedParameters.put("type", type);
        hql.append(" and ma.member in ");
        hql.append("      (from Member m where 1 = 1 ");
        hql.append("       and m.group = :group ) ");
        namedParameters.put("group", group);
        this.bulkUpdate(hql.toString(), namedParameters);
    }

    @Override
    public Iterator<MemberTransactionDetailsReportData> membersTransactionsDetailsReport(MembersTransactionsReportParameters params) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        HashSet ttIds = null;
        if (CollectionUtils.isNotEmpty(params.getPaymentFilters())) {
            ttIds = new HashSet();
            for (PaymentFilter pf : params.getPaymentFilters()) {
                pf = this.getFetchDao().fetch(pf, PaymentFilter.Relationships.TRANSFER_TYPES);
                Object[] ids = EntityHelper.toIds(pf.getTransferTypes());
                CollectionUtils.addAll(ttIds, (Object[])ids);
            }
        }
        HashSet groupIds = null;
        if (CollectionUtils.isNotEmpty(params.getMemberGroups())) {
            groupIds = new HashSet();
            CollectionUtils.addAll(groupIds, (Object[])EntityHelper.toIds(params.getMemberGroups()));
        }
        Period period = params.getPeriod();
        HibernateHelper.QueryParameter beginParameter = HibernateHelper.getBeginParameter(period);
        HibernateHelper.QueryParameter endParameter = HibernateHelper.getEndParameter(period);
        boolean useTT = CollectionUtils.isNotEmpty(ttIds);
        if (useTT) {
            parameters.put("ttIds", ttIds);
        }
        if (beginParameter != null) {
            parameters.put("beginDate", beginParameter.getValue());
        }
        if (endParameter != null) {
            parameters.put("endDate", endParameter.getValue());
        }
        parameters.put("processed", Payment.Status.PROCESSED.getValue());
        sql.append(" select u.username, m.name, bu.username broker_username, b.name broker_name, h.account_type_name, h.date, h.amount, h.description, h.related_username, h.related_name, h.transfer_type_name, h.transaction_number");
        sql.append(" from members m inner join users u on m.id = u.id left join members b on m.member_broker_id = b.id left join users bu on b.id = bu.id,");
        sql.append(" (");
        if (params.isCredits()) {
            this.appendMembersTransactionsDetailsReportSqlPart(sql, useTT, beginParameter, endParameter, true, true);
            sql.append(" union");
            this.appendMembersTransactionsDetailsReportSqlPart(sql, useTT, beginParameter, endParameter, true, false);
            if (params.isDebits()) {
                sql.append(" union");
            }
        }
        if (params.isDebits()) {
            this.appendMembersTransactionsDetailsReportSqlPart(sql, useTT, beginParameter, endParameter, false, true);
            sql.append(" union");
            this.appendMembersTransactionsDetailsReportSqlPart(sql, useTT, beginParameter, endParameter, false, false);
        }
        sql.append(" ) h");
        sql.append(" where m.id = h.member_id");
        if (groupIds != null) {
            parameters.put("groupIds", groupIds);
            sql.append(" and m.group_id in (:groupIds)");
        }
        sql.append(" order by m.name, u.username, h.account_type_name, h.date desc, h.transfer_id desc");
        SQLQuery query = this.getSession().createSQLQuery(sql.toString());
        final LinkedHashMap<String, Object> columns = new LinkedHashMap<String, Object>();
        columns.put("username", StandardBasicTypes.STRING);
        columns.put("name", StandardBasicTypes.STRING);
        columns.put("broker_username", StandardBasicTypes.STRING);
        columns.put("broker_name", StandardBasicTypes.STRING);
        columns.put("account_type_name", StandardBasicTypes.STRING);
        columns.put("date", StandardBasicTypes.CALENDAR);
        columns.put("amount", StandardBasicTypes.BIG_DECIMAL);
        columns.put("description", StandardBasicTypes.STRING);
        columns.put("related_username", StandardBasicTypes.STRING);
        columns.put("related_name", StandardBasicTypes.STRING);
        columns.put("transfer_type_name", StandardBasicTypes.STRING);
        columns.put("transaction_number", StandardBasicTypes.STRING);
        for (Map.Entry entry : columns.entrySet()) {
            query.addScalar((String)entry.getKey(), (Type)entry.getValue());
        }
        this.getHibernateQueryHandler().setQueryParameters((Query)query, parameters);
        Transformer<Object[], MemberTransactionDetailsReportData> transformer = new Transformer<Object[], MemberTransactionDetailsReportData>(){

            @Override
            public MemberTransactionDetailsReportData transform(Object[] input) {
                MemberTransactionDetailsReportData data = new MemberTransactionDetailsReportData();
                int i = 0;
                for (Map.Entry entry : columns.entrySet()) {
                    String columnName = (String)entry.getKey();
                    String propertyName = WordUtils.capitalize((String)columnName, (char[])COLUMN_DELIMITERS);
                    propertyName = Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1);
                    propertyName = StringUtils.replace((String)propertyName, (String)"_", (String)"");
                    PropertyHelper.set(data, propertyName, input[i]);
                    ++i;
                }
                return data;
            }
        };
        return new ScrollableResultsIterator<MemberTransactionDetailsReportData>((Query)query, transformer);
    }

    @Override
    public Iterator<MemberTransactionSummaryVO> membersTransactionSummaryReport(Collection<MemberGroup> memberGroups, PaymentFilter paymentFilter, Period period, boolean credits, LocalSettings.MemberResultDisplay order) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        List<Long> ttIds = paymentFilter == null ? null : Arrays.asList(EntityHelper.toIds(paymentFilter.getTransferTypes()));
        List<Long> groupIds = null;
        if (CollectionUtils.isNotEmpty(memberGroups)) {
            groupIds = Arrays.asList(EntityHelper.toIds(memberGroups));
        }
        HibernateHelper.QueryParameter beginParameter = HibernateHelper.getBeginParameter(period);
        HibernateHelper.QueryParameter endParameter = HibernateHelper.getEndParameter(period);
        boolean useGroups = CollectionUtils.isNotEmpty(groupIds);
        boolean useTT = CollectionUtils.isNotEmpty(ttIds);
        if (useGroups) {
            parameters.put("groupIds", groupIds);
        }
        if (useTT) {
            parameters.put("ttIds", ttIds);
        }
        if (beginParameter != null) {
            parameters.put("beginDate", beginParameter.getValue());
        }
        if (endParameter != null) {
            parameters.put("endDate", endParameter.getValue());
        }
        parameters.put("processed", Payment.Status.PROCESSED.getValue());
        sql.append(" select member_id, sum(count) as count, sum(amount) as amount");
        sql.append(" from (");
        this.appendMembersTransactionsSummaryReportSqlPart(sql, useGroups, useTT, beginParameter, endParameter, credits, true);
        sql.append(" union");
        this.appendMembersTransactionsSummaryReportSqlPart(sql, useGroups, useTT, beginParameter, endParameter, credits, false);
        sql.append(" ) ts");
        sql.append(" group by member_id");
        sql.append(" order by ").append(order == LocalSettings.MemberResultDisplay.NAME ? "member_name, member_id" : "username");
        SQLQuery query = this.getSession().createSQLQuery(sql.toString());
        query.addScalar("member_id", (Type)StandardBasicTypes.LONG);
        query.addScalar("count", (Type)StandardBasicTypes.INTEGER);
        query.addScalar("amount", (Type)StandardBasicTypes.BIG_DECIMAL);
        this.getHibernateQueryHandler().setQueryParameters((Query)query, parameters);
        Transformer<Object[], MemberTransactionSummaryVO> transformer = new Transformer<Object[], MemberTransactionSummaryVO>(){

            @Override
            public MemberTransactionSummaryVO transform(Object[] input) {
                MemberTransactionSummaryVO vo = new MemberTransactionSummaryVO();
                vo.setMemberId((Long)input[0]);
                vo.setCount((Integer)input[1]);
                vo.setAmount((BigDecimal)input[2]);
                return vo;
            }
        };
        return new ScrollableResultsIterator<MemberTransactionSummaryVO>((Query)query, transformer);
    }

    public List<Account> search(AccountQuery query) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        Set<Relationship> fetch = query.getFetch();
        Class<Object> entityClass = this.getEntityType();
        if (query.getOwner() != null) {
            entityClass = query.getOwner() instanceof SystemAccountOwner ? SystemAccount.class : MemberAccount.class;
        }
        StringBuilder hql = HibernateHelper.getInitialQuery(entityClass, "a", fetch);
        HibernateHelper.addParameterToQuery(hql, namedParameters, "a.type", query.getType());
        if (query.getOwner() instanceof Member) {
            HibernateHelper.addParameterToQuery(hql, namedParameters, "a.member", query.getOwner());
        }
        HibernateHelper.appendOrder(hql, "a.type.name");
        return this.list(query, hql.toString(), namedParameters);
    }

    private void appendMembersTransactionsDetailsReportSqlPart(StringBuilder sql, boolean useTT, HibernateHelper.QueryParameter beginParameter, HibernateHelper.QueryParameter endParameter, boolean credits, boolean notChargeBack) {
        boolean flag = notChargeBack ? credits : !credits;
        String account = flag ? "to_account_id" : "from_account_id";
        String related = flag ? "from_account_id" : "to_account_id";
        sql.append(" select a.member_id, at.id as account_type_id, at.name account_type_name, t.id transfer_id, t.process_date date, " + (credits ? "" : "-1 * ") + "abs(t.amount) amount, t.description, ra.owner_name related_username, rm.name related_name, tt.name transfer_type_name, t.transaction_number");
        sql.append(" from transfers t inner join accounts a on t.").append(account).append(" = a.id inner join accounts ra on t.").append(related).append(" = ra.id inner join transfer_types tt on t.type_id = tt.id inner join account_types at on a.type_id = at.id left join members rm on ra.member_id = rm.id");
        sql.append(" where t.status = :processed");
        sql.append("   and t.chargeback_of_id is ").append(notChargeBack ? "" : "not ").append("null");
        if (useTT) {
            sql.append("   and t.type_id in (:ttIds)");
        }
        if (beginParameter != null) {
            sql.append("   and t.process_date " + beginParameter.getOperator() + " :beginDate");
        }
        if (endParameter != null) {
            sql.append("   and t.process_date " + endParameter.getOperator() + " :endDate");
        }
    }

    private void appendMembersTransactionsSummaryReportSqlPart(StringBuilder sql, boolean useGroups, boolean useTT, HibernateHelper.QueryParameter beginParameter, HibernateHelper.QueryParameter endParameter, boolean credits, boolean notChargeBack) {
        boolean flag = notChargeBack ? credits : !credits;
        String account = flag ? "to_account_id" : "from_account_id";
        sql.append(" select m.id as member_id, m.name as member_name, u.username, count(t.id) as count, sum(abs(t.amount)) as amount");
        sql.append(" from transfers t inner join accounts a on t.").append(account).append(" = a.id inner join members m on a.member_id = m.id inner join users u on m.id = u.id");
        sql.append(" where t.status = :processed");
        sql.append("   and t.chargeback_of_id is ").append(notChargeBack ? "null" : "not null");
        if (useGroups) {
            sql.append("   and m.group_id in (:groupIds)");
        }
        if (useTT) {
            sql.append("   and t.type_id in (:ttIds)");
        }
        if (beginParameter != null) {
            sql.append("   and t.process_date " + beginParameter.getOperator() + " :beginDate");
        }
        if (endParameter != null) {
            sql.append("   and t.process_date " + endParameter.getOperator() + " :endDate");
        }
        sql.append(" group by m.id, m.name, u.username");
    }

    private TransactionSummaryVO buildSummary(Object object) {
        Object[] row = (Object[])object;
        int count = row[0] == null ? 0 : (Integer)row[0];
        BigDecimal amount = row[1] == null ? BigDecimal.ZERO : (BigDecimal)row[1];
        return new TransactionSummaryVO(count, amount);
    }

    private TransactionSummaryVO getSummary(GetTransactionsDTO dto, boolean credits, Payment.Status status) {
        Account account = this.load(dto.getOwner(), dto.getType(), new Relationship[0]);
        Member relatedToMember = dto.getRelatedToMember();
        Element by = dto.getBy();
        Period period = dto.getPeriod();
        Collection<PaymentFilter> paymentFilters = dto.getPaymentFilters();
        StringBuilder hql = new StringBuilder();
        HashMap<String, Object> namedParams = new HashMap<String, Object>();
        hql.append(" select count(*), sum(abs(t.amount))");
        hql.append(" from " + Transfer.class.getName() + " t");
        hql.append(" where ((t.amount > 0 and t.").append(credits ? "to" : "from").append(" = :account) ");
        hql.append("  or (t.amount < 0 and t.").append(credits ? "from" : "to").append(" = :account)) ");
        namedParams.put("account", account);
        HibernateHelper.addParameterToQuery(hql, namedParams, "t.status", status);
        if (dto.isRootOnly()) {
            hql.append(" and t.parent is null");
        }
        if (relatedToMember != null) {
            hql.append(" and exists (");
            hql.append("     select ma.id from MemberAccount ma ");
            hql.append("     where ma.member = :relatedToMember ");
            hql.append("     and (t.from = ma or t.to = ma) ");
            hql.append(" )");
            namedParams.put("relatedToMember", relatedToMember);
        }
        if (CollectionUtils.isNotEmpty(paymentFilters)) {
            HashSet<TransferType> transferTypes = new HashSet<TransferType>();
            for (PaymentFilter paymentFilter : paymentFilters) {
                if (paymentFilter == null || paymentFilter.isTransient() || (paymentFilter = this.getFetchDao().fetch(paymentFilter, PaymentFilter.Relationships.TRANSFER_TYPES)).getTransferTypes() == null) continue;
                transferTypes.addAll(paymentFilter.getTransferTypes());
            }
            if (CollectionUtils.isNotEmpty(transferTypes)) {
                hql.append(" and t.type in (:transferTypes) ");
                namedParams.put("transferTypes", transferTypes);
            }
        }
        if (by != null) {
            hql.append(" and (t.by = :by or t.receiver = :by)");
            namedParams.put("by", by);
        }
        HibernateHelper.addPeriodParameterToQuery(hql, namedParams, "ifnull(t.processDate,t.date)", period);
        return this.buildSummary(this.uniqueResult(hql.toString(), namedParams));
    }

    private class DiffsIterator
    implements Iterator<AccountDailyDifference>,
    Closeable {
        private final ScrollableResults results;
        private AccountDailyDifference diff;

        public DiffsIterator(ScrollableResults results) {
            this.results = results;
            this.advance();
        }

        @Override
        public void close() throws IOException {
            this.results.close();
        }

        @Override
        public boolean hasNext() {
            return this.diff != null;
        }

        @Override
        public AccountDailyDifference next() {
            AccountDailyDifference result = this.diff;
            this.advance();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void advance() {
            Calendar day;
            if (!this.results.next()) {
                this.diff = null;
                return;
            }
            this.diff = new AccountDailyDifference();
            this.diff.setDay(this.results.getCalendar(1));
            this.diff.setBalance(BigDecimal.ZERO);
            this.diff.setReserved(BigDecimal.ZERO);
            this.readAmount();
            boolean shouldRewind = true;
            if (this.results.next() && (day = this.results.getCalendar(1)).equals(this.diff.getDay())) {
                shouldRewind = false;
                this.readAmount();
            }
            if (shouldRewind) {
                this.results.previous();
            }
        }

        private void readAmount() {
            String type = this.results.getString(0);
            BigDecimal amount = this.results.getBigDecimal(2);
            if ("R".equals(type)) {
                this.diff.setReserved(amount);
            } else {
                this.diff.setBalance(amount);
            }
        }
    }
}

