/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.accounts;

import java.sql.SQLException;
import java.util.Calendar;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.JDBCCallback;
import nl.strohalm.cyclos.dao.accounts.AccountLimitLogDAO;
import nl.strohalm.cyclos.entities.accounts.AccountLimitLog;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.utils.JDBCWrapper;
import nl.strohalm.cyclos.utils.access.LoggedUser;

public class AccountLimitLogDAOImpl
extends BaseDAOImpl<AccountLimitLog>
implements AccountLimitLogDAO {
    public AccountLimitLogDAOImpl() {
        super(AccountLimitLog.class);
    }

    @Override
    public void insertAfterCreditLimitBulkUpdate(final MemberAccountType accountType, final MemberGroup group) {
        this.runNative(new JDBCCallback(){

            @Override
            public void execute(JDBCWrapper jdbc) throws SQLException {
                StringBuilder sql = new StringBuilder();
                sql.append("insert into account_limit_logs ");
                sql.append("(account_id, date, by_id, credit_limit, upper_credit_limit) ");
                sql.append(" select ");
                sql.append(" a.id, ?, ?, a.credit_limit, a.upper_credit_limit ");
                sql.append(" from accounts a, members m ");
                sql.append(" where a.member_id = m.id ");
                sql.append(" and m.group_id = ? and a.type_id = ? ");
                Calendar date = Calendar.getInstance();
                Long byId = ((Administrator)LoggedUser.element()).getId();
                Long groupId = group.getId();
                Long typeId = accountType.getId();
                jdbc.execute(sql.toString(), date, byId, groupId, typeId);
            }
        });
    }
}

