/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.accounts;

import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.accounts.AccountRatesDAO;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountRates;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.services.accounts.rates.WhatRate;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;

public class AccountRatesDAOImpl
extends BaseDAOImpl<AccountRates>
implements AccountRatesDAO {
    public AccountRatesDAOImpl() {
        super(AccountRates.class);
    }

    @Override
    public void bulkDelete(Account account, Period period) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder();
        hql.append("delete from AccountRates where ");
        hql.append(" account = :account ");
        namedParameters.put("account", account);
        hql.append(" and lastTransfer in ");
        hql.append("      (from Transfer t where ");
        hql.append(" (t.from.id = :account or t.to.id = :account) ");
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "t.processDate", period);
        hql.append(" )      ");
        this.bulkUpdate(hql.toString(), namedParameters);
    }

    @Override
    public void bulkUpdateWithNull(Currency currency, Period period, WhatRate whatRate) {
        boolean any;
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        boolean bl = any = whatRate.isaRate() || whatRate.isdRate() || whatRate.isiRate();
        if (!any) {
            return;
        }
        StringBuilder hql = new StringBuilder();
        hql.append("update AccountRates set ");
        boolean commaNeeded = false;
        if (whatRate.isaRate()) {
            hql.append(" emissionDate = null ");
            commaNeeded = true;
        }
        if (whatRate.isdRate()) {
            hql.append(commaNeeded ? " , " : "").append(" expirationDate = null ");
            commaNeeded = true;
        }
        if (whatRate.isiRate()) {
            hql.append(commaNeeded ? " , " : "").append(" iRate = null ");
            commaNeeded = true;
        }
        if (any) {
            hql.append(" , rateBalanceCorrection = null ");
        }
        hql.append(" where 1 = 1 ");
        if (currency != null) {
            hql.append(" and account in ");
            hql.append("      (from Account a where 1 = 1 ");
            hql.append("       and a.type.currency = :currency ) ");
            namedParameters.put("currency", currency);
        }
        hql.append(" and lastTransfer in ");
        hql.append("      (from Transfer t where 1 = 1 ");
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "t.processDate", period);
        hql.append(" )      ");
        this.bulkUpdate(hql.toString(), namedParameters);
    }

    @Override
    public AccountRates getLatestRates(Account account, Calendar date) throws IllegalArgumentException {
        Calendar requestedDate;
        AccountRates lastKnownRates = this.getRates(account, null);
        if (lastKnownRates == null) {
            AccountRates result = new AccountRates();
            result.setAccount(account);
            return result;
        }
        Calendar calendar = requestedDate = date == null ? Calendar.getInstance() : date;
        if (DateHelper.sameDay(requestedDate, lastKnownRates.getLastTransfer().getProcessDate())) {
            return lastKnownRates;
        }
        if (requestedDate.before(lastKnownRates.getLastTransfer().getProcessDate())) {
            throw new IllegalArgumentException("payments in past not allowed with rates enabled.");
        }
        AccountRates newRates = this.duplicate(lastKnownRates);
        return newRates;
    }

    @Override
    public AccountRates getLatestReinitializedRates(Account account, Calendar date, WhatRate whatRate) {
        Period period = Period.endingAt(date);
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder();
        hql.append(" from AccountRates r ");
        hql.append(" where 1=1 ");
        hql.append(" and r.account = :account ");
        params.put("account", account);
        HibernateHelper.addPeriodParameterToQuery(hql, params, "r.lastTransfer.processDate", period);
        hql.append(" order by r.lastTransfer.processDate desc");
        List list = this.list(hql.toString(), params);
        AccountRates entity = null;
        boolean empty = false;
        if (list.size() > 0) {
            entity = (AccountRates)list.get(0);
            if (whatRate.isaRate() && entity.getEmissionDate() == null || whatRate.isdRate() && entity.getExpirationDate() == null || whatRate.isiRate() && entity.getiRate() == null) {
                if (list.size() > 1) {
                    entity = (AccountRates)list.get(1);
                    if (whatRate.isaRate() && entity.getEmissionDate() == null || whatRate.isdRate() && entity.getExpirationDate() == null || whatRate.isiRate() && entity.getiRate() == null) {
                        empty = true;
                    }
                } else {
                    empty = true;
                }
            }
        } else {
            empty = true;
        }
        return empty ? new AccountRates() : entity;
    }

    @Override
    public AccountRates getRates(Account account, Calendar date) {
        HashMap<String, Cloneable> params = new HashMap<String, Cloneable>();
        StringBuilder hql = new StringBuilder();
        hql.append(" from AccountRates r ");
        hql.append(" where 1=1 ");
        hql.append(" and r.account = :account ");
        params.put("account", account);
        if (date != null) {
            hql.append(" and r.lastTransfer.processDate <= :date ");
            params.put("date", date);
        }
        hql.append(" order by r.lastTransfer.processDate desc");
        return (AccountRates)this.uniqueResult(hql.toString(), params);
    }

    @Override
    public AccountRates getTodaysRates(Account account, Calendar date) {
        Period period = Period.exact(date);
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder();
        hql.append(" from AccountRates r ");
        hql.append(" where 1=1 ");
        hql.append(" and r.account = :account ");
        params.put("account", account);
        HibernateHelper.addPeriodParameterToQuery(hql, params, "r.lastTransfer.processDate", period);
        hql.append(" order by r.lastTransfer.processDate desc");
        AccountRates result = (AccountRates)this.uniqueResult(hql.toString(), params);
        if (result == null && (result = this.duplicate(this.getRates(account, date))) == null) {
            result = new AccountRates();
            result.setAccount(account);
        }
        return result;
    }
}

