/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.accounts;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.accounts.AccountTypeDAO;
import nl.strohalm.cyclos.dao.accounts.transactions.TransferTypeDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.AccountTypeQuery;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.MemberGroupAccountSettings;
import nl.strohalm.cyclos.entities.accounts.SystemAccountType;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFee;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.accounts.MemberAccountTypeQuery;
import nl.strohalm.cyclos.services.accounts.SystemAccountTypeQuery;
import nl.strohalm.cyclos.utils.BigDecimalHelper;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import org.apache.commons.lang.ArrayUtils;

public class AccountTypeDAOImpl
extends BaseDAOImpl<AccountType>
implements AccountTypeDAO {
    private TransferTypeDAO transferTypeDao;

    public AccountTypeDAOImpl() {
        super(AccountType.class);
    }

    @Override
    public int delete(boolean flush, Long ... ids) {
        int rows = 0;
        for (Long id : ids) {
            try {
                AccountType accountType = (AccountType)this.load(id, AccountType.Relationships.FROM_TRANSFER_TYPES, AccountType.Relationships.TO_TRANSFER_TYPES);
                Long[] ttIds = (Long[])ArrayUtils.addAll((Object[])EntityHelper.toIds(accountType.getFromTransferTypes()), (Object[])EntityHelper.toIds(accountType.getToTransferTypes()));
                this.transferTypeDao.delete(ttIds);
                if (accountType instanceof SystemAccountType) {
                    SystemAccountType systemAccountType = (SystemAccountType)accountType;
                    for (AdminGroup group : systemAccountType.getViewedByGroups()) {
                        group.getViewInformationOf().remove(systemAccountType);
                    }
                }
                if (accountType instanceof MemberAccountType) {
                    Map<String, AccountType> params = Collections.singletonMap("type", accountType);
                    this.bulkUpdate("delete from " + AccountFee.class.getName() + " e where e.accountType = :type", params);
                }
                this.getHibernateTemplate().refresh((Object)accountType);
                this.getHibernateTemplate().delete((Object)accountType);
                ++rows;
            }
            catch (EntityNotFoundException e) {
                // empty catch block
            }
        }
        return rows;
    }

    @Override
    public BigDecimal getBalance(MemberAccountType accountType, Collection<MemberGroup> groups, Calendar timePoint) {
        return this.doGetBalance(accountType, groups, timePoint);
    }

    @Override
    public BigDecimal getBalance(SystemAccountType accountType, Calendar timePoint) {
        return this.doGetBalance(accountType, null, timePoint);
    }

    @Override
    public List<? extends AccountType> listAll() {
        return this.list("from AccountType at order by at.name", null);
    }

    @Override
    public List<AccountType> search(AccountTypeQuery query) {
        Class entityType = query instanceof SystemAccountTypeQuery ? SystemAccountType.class : MemberAccountType.class;
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        Set<Relationship> fetch = query.getFetch();
        StringBuilder hql = HibernateHelper.getInitialQuery(entityType, "at", fetch);
        HibernateHelper.addLikeParameterToQuery(hql, namedParameters, "at.description", query.getDescription());
        HibernateHelper.addLikeParameterToQuery(hql, namedParameters, "at.name", query.getName());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "at.currency", query.getCurrency());
        if (query instanceof SystemAccountTypeQuery) {
            SystemAccountTypeQuery systemQuery = (SystemAccountTypeQuery)query;
            if (systemQuery.getLimited() != null) {
                if (systemQuery.getLimited().booleanValue()) {
                    hql.append(" and at.account.creditLimit is not null ");
                } else {
                    hql.append(" and at.account.creditLimit is null ");
                }
            }
        } else {
            MemberAccountTypeQuery memberQuery = (MemberAccountTypeQuery)query;
            if (memberQuery.getOwner() != null) {
                Member member = this.getFetchDao().fetch(memberQuery.getOwner(), Element.Relationships.GROUP);
                memberQuery.setRelatedToGroup(member.getMemberGroup());
            }
            if (memberQuery.getRelatedToGroups() != null && !memberQuery.getRelatedToGroups().isEmpty()) {
                hql.append(" and exists (select mgaso.id from " + MemberGroupAccountSettings.class.getName() + " mgaso where mgaso.group in (:relatedGroups) and mgaso.accountType = at)");
                namedParameters.put("relatedGroups", memberQuery.getRelatedToGroups());
            }
            if (memberQuery.getNotRelatedToGroups() != null && !memberQuery.getNotRelatedToGroups().isEmpty()) {
                hql.append(" and not exists (select mgaso.id from " + MemberGroupAccountSettings.class.getName() + " mgaso where mgaso.group in (:notRelatedGroups) and mgaso.accountType = at)");
                namedParameters.put("notRelatedGroups", memberQuery.getNotRelatedToGroups());
            }
        }
        HibernateHelper.appendOrder(hql, "at.class", "at.name");
        return this.list(query, hql.toString(), namedParameters);
    }

    public void setTransferTypeDao(TransferTypeDAO transferTypeDao) {
        this.transferTypeDao = transferTypeDao;
    }

    private BigDecimal doGetBalance(AccountType accountType, Collection<MemberGroup> groups, Calendar timePoint) {
        BigDecimal credits = this.getSum(accountType, timePoint, groups, true);
        BigDecimal debits = this.getSum(accountType, timePoint, groups, false);
        return credits.subtract(debits);
    }

    private BigDecimal getSum(AccountType accountType, Calendar timePoint, Collection<MemberGroup> groups, boolean credits) {
        StringBuilder hql = new StringBuilder();
        HashMap<String, Object> namedParams = new HashMap<String, Object>();
        hql.append(" select sum(abs(t.amount))");
        hql.append(" from Transfer t");
        hql.append(" where ((t.chargebackOf.id is null and t.").append(credits ? "to" : "from").append(".type = :accountType )");
        hql.append("       or (t.chargebackOf.id is not null and t.").append(!credits ? "to" : "from").append(".type = :accountType ))");
        if (timePoint == null) {
            hql.append(" and t.processDate is not null");
        } else {
            hql.append(" and t.processDate <= :timePoint");
            namedParams.put("timePoint", timePoint);
        }
        if (groups != null) {
            hql.append(" and exists (");
            hql.append("     select 1");
            hql.append("     from MemberAccount ma");
            hql.append("     where ma.member.group in (:groups)");
            hql.append("     and (ma = t.from or ma = t.to)");
            hql.append(" )");
            namedParams.put("groups", groups);
        }
        namedParams.put("accountType", accountType);
        BigDecimal result = (BigDecimal)this.uniqueResult(hql.toString(), namedParams);
        return BigDecimalHelper.nvl(result);
    }
}

