/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.accounts;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.accounts.CurrencyDAO;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.MemberGroup;

public class CurrencyDAOImpl
extends BaseDAOImpl<Currency>
implements CurrencyDAO {
    public CurrencyDAOImpl() {
        super(Currency.class);
    }

    @Override
    public int delete(boolean flush, Long ... ids) {
        for (Long id : ids) {
            HashMap<String, Currency> namedParameters = new HashMap<String, Currency>();
            Currency currency = (Currency)this.load(id, new Relationship[0]);
            currency.setaRateParameters(null);
            currency.setdRateParameters(null);
            currency.setiRateParameters(null);
            this.update(currency);
            namedParameters.put("currency", currency);
            this.bulkUpdate("delete from ARateParameters r where r.currency = :currency", namedParameters);
            this.bulkUpdate("delete from DRateParameters r where r.currency = :currency", namedParameters);
            this.bulkUpdate("delete from IRateParameters r where r.currency = :currency", namedParameters);
        }
        return super.delete(flush, ids);
    }

    @Override
    public List<Currency> listAll(Relationship ... fetch) {
        List<Currency> currencies = this.list("from Currency c order by c.name", null);
        for (int i = 0; i < currencies.size(); ++i) {
            currencies.set(i, (Currency)this.getFetchDao().fetch((Entity)currencies.get(i), fetch));
        }
        return currencies;
    }

    @Override
    public List<Currency> listByMemberGroup(MemberGroup group) {
        String hql = "from Currency c where exists (select mgas.id from MemberGroupAccountSettings mgas where mgas.group = :group and mgas.accountType.currency = c) order by c.name";
        Map<String, MemberGroup> namedParameters = Collections.singletonMap("group", group);
        return this.list("from Currency c where exists (select mgas.id from MemberGroupAccountSettings mgas where mgas.group = :group and mgas.accountType.currency = c) order by c.name", namedParameters);
    }

    @Override
    public Currency loadBySymbol(String symbol, Relationship ... fetch) throws EntityNotFoundException {
        Map<String, String> params = Collections.singletonMap("symbol", symbol);
        Currency currency = (Currency)this.uniqueResult("from Currency c where c.symbol = :symbol", params);
        if (currency == null) {
            throw new EntityNotFoundException(Currency.class);
        }
        return this.getFetchDao().fetch(currency, fetch);
    }
}

