/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.accounts;

import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.accounts.RateParametersDAO;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.RateParameters;
import nl.strohalm.cyclos.utils.Period;

public abstract class RateParametersDAOImpl<R extends RateParameters>
extends BaseDAOImpl<R>
implements RateParametersDAO<R> {
    public RateParametersDAOImpl(Class<R> entityClass) {
        super(entityClass);
    }

    @Override
    public R getByDate(Currency currency, Calendar date) {
        HashMap<String, Cloneable> params = new HashMap<String, Cloneable>();
        params.put("currency", currency);
        StringBuilder hql = new StringBuilder();
        hql.append(" from ").append(this.getEntityType().getName()).append(" r ");
        hql.append(" where r.currency = :currency ");
        if (date != null) {
            hql.append(" and r.enabledSince <= :date ");
            hql.append(" and (r.disabledSince is null or r.disabledSince > :date) ");
            params.put("date", date);
        }
        hql.append(" order by r.enabledSince desc");
        return (R)((RateParameters)this.uniqueResult(hql.toString(), params));
    }

    @Override
    public List<R> getByPeriod(Currency currency, Period period) {
        HashMap<String, Cloneable> params = new HashMap<String, Cloneable>();
        params.put("currency", currency);
        StringBuilder hql = new StringBuilder();
        hql.append(" from ").append(this.getEntityType().getName()).append(" r ");
        hql.append(" where r.currency = :currency ");
        if (period != null && period.getBegin() != null) {
            params.put("startDate", period.getBegin());
            hql.append(" and (r.disabledSince is null or (r.disabledSince is not null and r.disabledSince > :startDate)) ");
        }
        if (period != null && period.getEnd() != null) {
            params.put("endDate", period.getEnd());
            hql.append(" and (r.enabledSince <= :endDate)) ");
        }
        hql.append(" order by r.enabledSince desc");
        return this.list(hql.toString(), params);
    }
}

