/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.accounts.cards;

import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.accounts.cards.CardDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.cards.Card;
import nl.strohalm.cyclos.entities.accounts.cards.CardQuery;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import org.apache.commons.lang.ArrayUtils;

public class CardDAOImpl
extends BaseDAOImpl<Card>
implements CardDAO {
    public CardDAOImpl() {
        super(Card.class);
    }

    @Override
    public void cancelAllMemberCards(Member member) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        namedParameters.put("owner", member);
        namedParameters.put("status", Card.Status.CANCELED);
        this.bulkUpdate("update " + this.getEntityType().getName() + " set status = :status where owner = :owner ", namedParameters);
    }

    @Override
    public boolean existsNumber(BigInteger cardNumber) throws DaoException {
        StringBuilder hql = new StringBuilder();
        HashMap<String, BigInteger> namedParameters = new HashMap<String, BigInteger>();
        hql.append(" select count(*)");
        hql.append(" from " + Card.class.getName() + " c");
        hql.append(" where c.cardNumber = :cardNumber ");
        namedParameters.put("cardNumber", cardNumber);
        Integer count = (Integer)this.uniqueResult(hql.toString(), namedParameters);
        boolean hasCardNumber = count != 0;
        return hasCardNumber;
    }

    @Override
    public List<Card> getCardsToExpire(Calendar expirationDate) {
        StringBuilder hql = new StringBuilder("select c from " + this.getEntityType().getName() + " c");
        hql.append(" where c.expirationDate < :expirationDate ");
        hql.append(" and c.status <> :status ");
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        namedParameters.put("expirationDate", expirationDate);
        namedParameters.put("status", Card.Status.EXPIRED);
        return this.list(hql.toString(), namedParameters);
    }

    @Override
    public List<Card> getMemberCards(long memberId) {
        HashMap<String, Long> namedParameters = new HashMap<String, Long>();
        StringBuilder hql = new StringBuilder("select c from " + Card.class.getName() + " c");
        hql.append(" where c.owner.id = :memberId ");
        namedParameters.put("memberId", memberId);
        HibernateHelper.appendOrder(hql, "c.creationDate desc");
        return this.list(hql.toString(), namedParameters);
    }

    @Override
    public Calendar lastTimeExpiredCards() {
        HashMap<String, Card.Status> namedParameters = new HashMap<String, Card.Status>();
        StringBuilder hql = new StringBuilder("select max(c.expirationDate) from " + Card.class.getName() + " c");
        hql.append(" where c.status = :status ");
        namedParameters.put("status", Card.Status.EXPIRED);
        return (Calendar)this.uniqueResult(hql.toString(), namedParameters);
    }

    @Override
    public Card loadByNumber(BigInteger number, Relationship ... fetch) {
        Card card = (Card)this.uniqueResult("from Card c where c.cardNumber = :number", Collections.singletonMap("number", number));
        if (card == null) {
            throw new EntityNotFoundException(Card.class);
        }
        if (!ArrayUtils.isEmpty((Object[])fetch)) {
            card = this.getFetchDao().fetch(card, fetch);
        }
        return card;
    }

    @Override
    public Card getLastCard(long memberId) throws DaoException {
        Map<String, Long> namedParameters = Collections.singletonMap("memberId", memberId);
        StringBuilder hql = new StringBuilder();
        hql.append(" from " + Card.class.getName() + " c");
        hql.append(" where c.owner.id = :memberId ");
        hql.append(" order by c.creationDate desc");
        return (Card)this.uniqueResult(hql.toString(), namedParameters);
    }

    @Override
    public List<Card> search(CardQuery query) throws DaoException {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        Set<Relationship> fetch = query.getFetch();
        StringBuilder hql = new StringBuilder("select c from " + this.getEntityType().getName() + " c");
        hql.append(" left join c.owner owr");
        HibernateHelper.appendJoinFetch(hql, this.getEntityType(), "c", fetch);
        hql.append(" where 1 = 1");
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "c.expirationDate", query.getExpiration());
        HibernateHelper.addInParameterToQuery(hql, namedParameters, "c.status", query.getStatus());
        HibernateHelper.addInParameterToQuery(hql, namedParameters, "owr.group", query.getGroups());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "c.cardType", query.getCardType());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "c.owner", query.getMember());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "c.cardNumber", query.getNumber());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "owr.broker", query.getBroker());
        HibernateHelper.appendOrder(hql, "owr.name", "c.creationDate desc");
        return this.list(query, hql.toString(), namedParameters);
    }

    @Override
    public List<Card> searchActiveCards(Long ownerId, Long cardId) {
        HashMap<String, Long> namedParameters = new HashMap<String, Long>();
        StringBuilder hql = new StringBuilder("select c from " + this.getEntityType().getName() + " c");
        hql.append(" where c.owner.id = :ownerId ");
        hql.append(" and   c.id != :cardId ");
        hql.append(" and c.status not in ('C','E')");
        namedParameters.put("ownerId", ownerId);
        namedParameters.put("cardId", cardId);
        return this.list(hql.toString(), namedParameters);
    }
}

