/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.accounts.external;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.accounts.external.ExternalAccountDAO;
import nl.strohalm.cyclos.entities.accounts.external.ExternalAccount;
import nl.strohalm.cyclos.entities.accounts.external.ExternalAccountDetailsVO;
import nl.strohalm.cyclos.entities.accounts.external.ExternalAccountQuery;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransfer;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;

public class ExternalAccountDAOImpl
extends BaseDAOImpl<ExternalAccount>
implements ExternalAccountDAO {
    public ExternalAccountDAOImpl() {
        super(ExternalAccount.class);
    }

    @Override
    public List<ExternalAccount> listAll() {
        return this.list("from ExternalAccount ea order by ea.name", null);
    }

    @Override
    public List<ExternalAccountDetailsVO> listExternalAccountOverview(ExternalAccountQuery query) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder();
        hql.append(" select ea");
        hql.append(" from ExternalAccount ea");
        hql.append(" where 1=1 ");
        HibernateHelper.addInParameterToQuery(hql, namedParameters, "ea.systemAccountType", query.getSystemAccountTypes());
        hql.append(" order by ea.name");
        List accounts = this.list(hql.toString(), namedParameters);
        ArrayList<ExternalAccountDetailsVO> result = new ArrayList<ExternalAccountDetailsVO>(accounts.size());
        for (ExternalAccount account : accounts) {
            namedParameters = new HashMap();
            namedParameters.put("account", account);
            namedParameters.put("possibleTransferStatus", EnumSet.of(ExternalTransfer.Status.CHECKED, ExternalTransfer.Status.PROCESSED));
            hql = new StringBuilder();
            hql.append(" select sum(t.amount)");
            hql.append(" from ExternalTransfer t ");
            hql.append(" where t.account = :account ");
            hql.append("   and t.status in (:possibleTransferStatus) ");
            BigDecimal balance = CoercionHelper.coerce(BigDecimal.class, this.uniqueResult(hql.toString(), namedParameters));
            result.add(new ExternalAccountDetailsVO(account.getId(), account.getName(), balance));
        }
        return result;
    }

    @Override
    public List<ExternalAccount> search(ExternalAccountQuery query) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = HibernateHelper.getInitialQuery(ExternalAccount.class, "ea", query.getFetch());
        HibernateHelper.addInParameterToQuery(hql, namedParameters, "ea.systemAccountType", query.getSystemAccountTypes());
        HibernateHelper.appendOrder(hql, "ea.name");
        return this.list(query, hql.toString(), namedParameters);
    }
}

