/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.accounts.external;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.accounts.external.ExternalTransferDAO;
import nl.strohalm.cyclos.entities.accounts.external.ExternalAccount;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransfer;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransferQuery;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransferType;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;

public class ExternalTransferDAOImpl
extends BaseDAOImpl<ExternalTransfer>
implements ExternalTransferDAO {
    public ExternalTransferDAOImpl() {
        super(ExternalTransfer.class);
    }

    @Override
    public List<ExternalTransfer> search(ExternalTransferQuery query) {
        ExternalAccount account = query.getAccount();
        if (account == null) {
            return Collections.emptyList();
        }
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = HibernateHelper.getInitialQuery(ExternalTransfer.class, "t", query.getFetch());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "t.account", account);
        HibernateHelper.addParameterToQuery(hql, namedParameters, "t.type", query.getType());
        if (query.isOnlyWithValidTypes()) {
            HibernateHelper.addParameterToQueryOperator(hql, namedParameters, "t.type.action", "<>", ExternalTransferType.Action.IGNORE);
        }
        namedParameters.put("ignore", ExternalTransferType.Action.IGNORE);
        if (query.getStatus() != null) {
            switch (query.getStatus()) {
                case COMPLETE_PENDING: 
                case INCOMPLETE_PENDING: {
                    boolean complete = query.getStatus() == ExternalTransfer.SummaryStatus.COMPLETE_PENDING;
                    HibernateHelper.addParameterToQuery(hql, namedParameters, "t.status", ExternalTransfer.Status.PENDING);
                    hql.append("and " + (complete ? "not" : "") + "(t.type is null or (t.type.action != :ignore and t.member is null) or t.date is null or t.amount is null)");
                    break;
                }
                case CHECKED: {
                    HibernateHelper.addParameterToQuery(hql, namedParameters, "t.status", ExternalTransfer.Status.CHECKED);
                    break;
                }
                case PROCESSED: {
                    HibernateHelper.addParameterToQuery(hql, namedParameters, "t.status", ExternalTransfer.Status.PROCESSED);
                }
            }
        }
        HibernateHelper.addParameterToQuery(hql, namedParameters, "t.transferImport", query.getTransferImport());
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "t.date", query.getPeriod());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "t.member", query.getMember());
        HibernateHelper.addParameterToQueryOperator(hql, namedParameters, "t.amount", ">=", query.getInitialAmount());
        HibernateHelper.addParameterToQueryOperator(hql, namedParameters, "t.amount", "<=", query.getFinalAmount());
        HibernateHelper.appendOrder(hql, "t.date desc", "t.amount");
        return this.list(query, hql.toString(), namedParameters);
    }
}

