/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.accounts.external;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.accounts.external.ExternalTransferImportDAO;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransfer;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransferImport;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransferImportQuery;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;

public class ExternalTransferImportDAOImpl
extends BaseDAOImpl<ExternalTransferImport>
implements ExternalTransferImportDAO {
    public ExternalTransferImportDAOImpl() {
        super(ExternalTransferImport.class);
    }

    @Override
    public boolean hasCheckedTransfers(Long ... ids) {
        if (ids == null || ids.length == 0) {
            return false;
        }
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder();
        hql.append(" select count(*)");
        hql.append(" from ").append(ExternalTransfer.class.getName()).append(" t");
        hql.append(" where t.transferImport.id in (:ids)");
        hql.append("   and t.status <> :pending");
        namedParameters.put("ids", Arrays.asList(ids));
        namedParameters.put("pending", ExternalTransfer.Status.PENDING);
        Number count = (Number)this.uniqueResult(hql.toString(), namedParameters);
        return count.intValue() > 0;
    }

    @Override
    public List<ExternalTransferImport> search(ExternalTransferImportQuery query) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = HibernateHelper.getInitialQuery(ExternalTransferImport.class, "i", query.getFetch());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "i.account", query.getAccount());
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "i.date", query.getPeriod());
        HibernateHelper.appendOrder(hql, "i.date desc");
        return this.list(query, hql.toString(), namedParameters);
    }
}

