/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.accounts.fee.account;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashMap;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.accounts.fee.account.AccountFeeAmountDAO;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFeeAmount;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFeeLog;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.utils.BigDecimalHelper;

public class AccountFeeAmountDAOImpl
extends BaseDAOImpl<AccountFeeAmount>
implements AccountFeeAmountDAO {
    public AccountFeeAmountDAOImpl() {
        super(AccountFeeAmount.class);
    }

    @Override
    public void deleteOnPeriod(MemberAccount account, AccountFeeLog log) {
        HashMap<String, Entity> namedParameters = new HashMap<String, Entity>();
        namedParameters.put("account", account);
        namedParameters.put("log", log);
        String hql = "delete from AccountFeeAmount c where c.account = :account and c.accountFeeLog = :log";
        this.bulkUpdate("delete from AccountFeeAmount c where c.account = :account and c.accountFeeLog = :log", namedParameters);
    }

    @Override
    public AccountFeeAmount forData(MemberAccount account, AccountFeeLog accountFeeLog, Calendar date) throws EntityNotFoundException {
        HashMap<String, Cloneable> params = new HashMap<String, Cloneable>();
        params.put("account", account);
        params.put("accountFeeLog", accountFeeLog);
        params.put("date", date);
        AccountFeeAmount charge = (AccountFeeAmount)this.uniqueResult("from AccountFeeAmount c where c.account = :account and c.accountFeeLog = :accountFeeLog and c.period.end = :date", params);
        if (charge == null) {
            throw new EntityNotFoundException(this.getEntityType());
        }
        return charge;
    }

    @Override
    public BigDecimal totalAmoutForPeriod(MemberAccount account, AccountFeeLog accountFeeLog) {
        HashMap<String, Entity> params = new HashMap<String, Entity>();
        params.put("account", account);
        params.put("accountFeeLog", accountFeeLog);
        BigDecimal amount = (BigDecimal)this.uniqueResult("select sum(c.amount) from AccountFeeAmount c where c.account = :account and c.accountFeeLog = :accountFeeLog", params);
        return BigDecimalHelper.nvl(amount);
    }
}

