/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.accounts.fee.account;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.accounts.fee.account.AccountFeeLogDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFee;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFeeLog;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFeeLogQuery;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;

public class AccountFeeLogDAOImpl
extends BaseDAOImpl<AccountFeeLog>
implements AccountFeeLogDAO {
    public AccountFeeLogDAOImpl() {
        super(AccountFeeLog.class);
    }

    @Override
    public AccountFeeLog forDate(AccountFee accountFee, Calendar date) throws EntityNotFoundException {
        HashMap<String, Cloneable> params = new HashMap<String, Cloneable>();
        params.put("accountFee", accountFee);
        params.put("date", date == null ? Calendar.getInstance() : date);
        AccountFeeLog log = (AccountFeeLog)this.uniqueResult("from AccountFeeLog l where l.accountFee = :accountFee and :date between l.period.begin and l.period.end", params);
        if (log == null) {
            throw new EntityNotFoundException(this.getEntityType());
        }
        return log;
    }

    @Override
    public Iterator<MemberAccount> iterateOverAccountsWithAccountFeeChargesFor(AccountFeeLog log) {
        HashMap<String, AccountFeeLog> namedParameters = new HashMap<String, AccountFeeLog>();
        StringBuilder hql = HibernateHelper.getInitialQuery(MemberAccount.class, "a");
        hql.append(" and exists(select c.id from AccountFeeCharge c where c.account = a and c.accountFeeLog = :log)");
        namedParameters.put("log", log);
        return this.iterate(hql.toString(), namedParameters);
    }

    @Override
    public AccountFeeLog nextToCharge() {
        return (AccountFeeLog)this.uniqueResult("from AccountFeeLog l where l.date <= now() and l.finishDate is null or l.rechargingFailed = true", null);
    }

    @Override
    public List<AccountFeeLog> search(AccountFeeLogQuery query) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        Set<Relationship> fetch = query.getFetch();
        StringBuilder hql = HibernateHelper.getInitialQuery(this.getEntityType(), "l", fetch);
        HibernateHelper.addInParameterToQuery(hql, namedParameters, "l.accountFee", query.getAccountFees());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "l.accountFee.enabled", query.getAccountFeeEnabled());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "l.accountFee.accountType", query.getAccountType());
        if (query.getPeriodStartAt() != null) {
            HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "l.period.begin", Period.day(query.getPeriodStartAt()));
        }
        HibernateHelper.appendOrder(hql, "l.date desc, l.id desc");
        return this.list(query, hql.toString(), namedParameters);
    }
}

