/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.accounts.fee.account;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.JDBCCallback;
import nl.strohalm.cyclos.dao.accounts.fee.account.MemberAccountFeeLogDAO;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFee;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFeeLog;
import nl.strohalm.cyclos.entities.accounts.fees.account.MemberAccountFeeLog;
import nl.strohalm.cyclos.entities.accounts.fees.account.MemberAccountFeeLogQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.Invoice;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.transactions.TransactionSummaryVO;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.JDBCWrapper;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import nl.strohalm.cyclos.utils.query.PageParameters;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableInt;

public class MemberAccountFeeLogDAOImpl
extends BaseDAOImpl<MemberAccountFeeLog>
implements MemberAccountFeeLogDAO {
    public MemberAccountFeeLogDAOImpl() {
        super(MemberAccountFeeLog.class);
    }

    @Override
    public int countSkippedMembers(AccountFeeLog log) {
        HashMap<String, AccountFeeLog> params = new HashMap<String, AccountFeeLog>();
        params.put("log", log);
        StringBuilder hql = new StringBuilder();
        hql.append(" select count(*) ");
        hql.append(" from MemberAccountFeeLog l");
        hql.append(" where l.accountFeeLog = :log");
        hql.append("   and l.success = true");
        hql.append("   and l.transfer.id is null");
        hql.append("   and l.invoice.id is null");
        return (Integer)this.uniqueResult(hql.toString(), params);
    }

    @Override
    public TransactionSummaryVO getAcceptedInvoicesSummary(AccountFeeLog log) {
        return this.doGetInvoicesSummary(log, true);
    }

    @Override
    public TransactionSummaryVO getInvoicesSummary(AccountFeeLog log) {
        return this.doGetInvoicesSummary(log, false);
    }

    @Override
    public AccountFeeLog getLastChargedLog(Member member, AccountFee fee) {
        HashMap<String, Entity> params = new HashMap<String, Entity>();
        params.put("member", member);
        params.put("fee", fee);
        String hql = "select ml.accountFeeLog from MemberAccountFeeLog ml where ml.member = :member and ml.accountFeeLog.accountFee = :fee order by ml.accountFeeLog.date desc, ml.id";
        return (AccountFeeLog)this.uniqueResult(hql, params);
    }

    @Override
    public TransactionSummaryVO getTransfersSummary(AccountFeeLog log) {
        Map<String, AccountFeeLog> params = Collections.singletonMap("log", log);
        StringBuilder hql = new StringBuilder();
        hql.append(" select new nl.strohalm.cyclos.services.transactions.TransactionSummaryVO(count(*), sum(l.amount)) ");
        hql.append(" from MemberAccountFeeLog l");
        hql.append(" where l.accountFeeLog = :log");
        hql.append(" and l.transfer.id is not null");
        return (TransactionSummaryVO)this.uniqueResult(hql.toString(), params);
    }

    @Override
    public MemberAccountFeeLog load(AccountFeeLog log, Member member) {
        HashMap<String, Entity> params = new HashMap<String, Entity>();
        params.put("log", log);
        params.put("member", member);
        return (MemberAccountFeeLog)this.uniqueResult("from MemberAccountFeeLog ml where ml.accountFeeLog = :log and ml.member = :member", params);
    }

    @Override
    public List<Member> nextFailedToCharge(AccountFeeLog feeLog, int count) {
        Collection<MemberGroup> groups = feeLog.getAccountFee().getGroups();
        if (groups.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, AccountFeeLog> parameters = new HashMap<String, AccountFeeLog>();
        parameters.put("log", feeLog);
        StringBuilder hql = new StringBuilder();
        hql.append(" select m");
        hql.append(" from MemberAccountFeeLog ml join ml.accountFeeLog l join ml.member m left join fetch m.user");
        hql.append(" where ml.success = false");
        hql.append("   and ml.rechargeAttempt < l.rechargeAttempt");
        hql.append("   and l = :log");
        return this.getHibernateQueryHandler().simpleList(null, hql.toString(), parameters, PageParameters.max(count), new Relationship[0]);
    }

    @Override
    public List<Member> nextToCharge(AccountFeeLog feeLog, int count) {
        return this.getSession().createFilter(feeLog.getPendingToCharge(), "where 1=1").setMaxResults(count).list();
    }

    @Override
    public int prepareCharge(AccountFeeLog log) {
        Object[] groupIds = EntityHelper.toIds(log.getAccountFee().getGroups());
        if (ArrayUtils.isEmpty((Object[])groupIds)) {
            return 0;
        }
        MutableInt result = new MutableInt();
        this.runNative(new JDBCCallback((Long[])groupIds, log, result){
            final /* synthetic */ Long[] val$groupIds;
            final /* synthetic */ AccountFeeLog val$log;
            final /* synthetic */ MutableInt val$result;
            {
                this.val$groupIds = longArray;
                this.val$log = accountFeeLog;
                this.val$result = mutableInt;
            }

            @Override
            public void execute(JDBCWrapper jdbc) throws SQLException {
                Object[] placeHolders = new String[this.val$groupIds.length];
                Arrays.fill(placeHolders, "?");
                StringBuilder sql = new StringBuilder();
                sql.append(" insert into members_pending_charge");
                sql.append(" (account_fee_log_id, member_id)");
                sql.append(" select ?, id");
                sql.append(" from members m");
                sql.append(" where m.subclass = ?");
                sql.append(" and m.group_id in (").append(StringUtils.join((Object[])placeHolders, (String)",")).append(')');
                ArrayList<Object> args = new ArrayList<Object>(this.val$groupIds.length + 2);
                args.add(this.val$log.getId());
                args.add("M");
                CollectionUtils.addAll(args, (Object[])this.val$groupIds);
                int totalMembers = jdbc.execute(sql.toString(), args.toArray());
                this.val$result.setValue(totalMembers);
            }
        });
        return result.intValue();
    }

    @Override
    public void remove(AccountFeeLog log, Member member) {
        HashMap<String, Entity> params = new HashMap<String, Entity>();
        params.put("log", log);
        params.put("member", member);
        this.bulkUpdate("delete from MemberAccountFeeLog ml where ml.accountFeeLog = :log and ml.member = :member", params);
    }

    @Override
    public void removePendingCharge(final AccountFeeLog feeLog, final Member member) {
        this.runNative(new JDBCCallback(){

            @Override
            public void execute(JDBCWrapper jdbc) throws SQLException {
                jdbc.execute("delete from members_pending_charge where account_fee_log_id = ? and member_id = ?", feeLog.getId(), member.getId());
            }
        });
    }

    @Override
    public List<MemberAccountFeeLog> search(MemberAccountFeeLogQuery query, LocalSettings.MemberResultDisplay sort) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder hql = HibernateHelper.getInitialQuery(this.getEntityType(), "m", query.getFetch());
        HibernateHelper.addParameterToQuery(hql, params, "m.accountFeeLog", query.getAccountFeeLog());
        HibernateHelper.addInParameterToQuery(hql, params, "m.member.group", query.getGroups());
        HibernateHelper.addParameterToQuery(hql, params, "m.member", query.getMember());
        MemberAccountFeeLogQuery.Status status = query.getStatus();
        if (status != null) {
            HibernateHelper.addParameterToQuery(hql, params, "m.success", status != MemberAccountFeeLogQuery.Status.ERROR);
            switch (status) {
                case SKIPPED: {
                    hql.append(" and m.transfer.id is null and m.invoice.id is null");
                    break;
                }
                case TRANSFER: {
                    hql.append(" and m.transfer.id is not null");
                    break;
                }
                case INVOICE: {
                    hql.append(" and m.invoice.id is not null");
                    break;
                }
                case ACCEPTED_INVOICE: {
                    HibernateHelper.addParameterToQuery(hql, params, "m.invoice.status", Invoice.Status.ACCEPTED);
                    break;
                }
                case OPEN_INVOICE: {
                    HibernateHelper.addParameterToQueryOperator(hql, params, "m.invoice.status", "<>", Invoice.Status.ACCEPTED);
                }
            }
        }
        HibernateHelper.appendOrder(hql, sort == LocalSettings.MemberResultDisplay.NAME ? "m.member.name" : "m.member.user.username");
        return this.list(query, hql.toString(), params);
    }

    private TransactionSummaryVO doGetInvoicesSummary(AccountFeeLog log, boolean accepted) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("log", log);
        StringBuilder hql = new StringBuilder();
        hql.append(" select new nl.strohalm.cyclos.services.transactions.TransactionSummaryVO(count(*), sum(l.amount)) ");
        hql.append(" from MemberAccountFeeLog l");
        if (accepted) {
            hql.append(" join l.invoice i ");
        }
        hql.append(" where l.accountFeeLog = :log");
        if (accepted) {
            hql.append(" and i.status = :accepted");
            params.put("accepted", Invoice.Status.ACCEPTED);
        } else {
            hql.append(" and l.invoice.id is not null");
        }
        return (TransactionSummaryVO)this.uniqueResult(hql.toString(), params);
    }
}

