/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.accounts.fee.transaction;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.accounts.fee.transaction.TransactionFeeDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.BrokerCommission;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFee;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFeeQuery;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;

public class TransactionFeeDAOImpl
extends BaseDAOImpl<TransactionFee>
implements TransactionFeeDAO {
    public TransactionFeeDAOImpl() {
        super(TransactionFee.class);
    }

    @Override
    public List<TransactionFee> search(TransactionFeeQuery query) {
        AccountType.Nature genTTFromNature;
        TransactionFee.Nature nature;
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        Set<Relationship> fetch = query.getFetch();
        Class<Object> entityType = this.getEntityType();
        if (query.getEntityType() != null) {
            entityType = query.getEntityType();
        }
        StringBuilder hql = HibernateHelper.getInitialQuery(entityType, "f", fetch);
        HibernateHelper.addLikeParameterToQuery(hql, namedParameters, "f.description", query.getDescription());
        HibernateHelper.addLikeParameterToQuery(hql, namedParameters, "f.name", query.getName());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "f.originalTransferType", query.getTransferType());
        if (!query.isReturnDisabled()) {
            hql.append(" and f.enabled = true ");
        }
        if ((nature = query.getNature()) != null) {
            HibernateHelper.addParameterToQuery(hql, namedParameters, "f.class", nature.getValue());
        }
        HibernateHelper.addParameterToQuery(hql, namedParameters, "f.generatedTransferType.from.class", (genTTFromNature = query.getGeneratedTransferTypeFromNature()) == null ? null : genTTFromNature.getValue());
        if (entityType == BrokerCommission.class && query.getBrokerGroup() != null) {
            hql.append(" and (f.allBrokerGroups = true or :brokerGroup in elements (f.brokerGroups) ) ");
            namedParameters.put("brokerGroup", query.getBrokerGroup());
        }
        if (query.getBrokerGroup() != null) {
            hql.append(" and (");
            hql.append("  (f.fromAllGroups = true or :memberGroup in elements (f.fromGroups)) or ");
            hql.append("  (f.toAllGroups = true or :memberGroup in elements (f.toGroups)) ");
            hql.append(" ) ");
            namedParameters.put("memberGroup", query.getMemberGroup());
        }
        HibernateHelper.appendOrder(hql, "f.name");
        return this.list(query, hql.toString(), namedParameters);
    }
}

