/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.accounts.guarantees;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.accounts.guarantees.CertificationDAO;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.guarantees.Certification;
import nl.strohalm.cyclos.entities.accounts.guarantees.CertificationQuery;
import nl.strohalm.cyclos.entities.accounts.guarantees.Guarantee;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import org.apache.commons.collections.CollectionUtils;

public class CertificationDAOImpl
extends BaseDAOImpl<Certification>
implements CertificationDAO {
    public CertificationDAOImpl() {
        super(Certification.class);
    }

    @Override
    public List<Certification> getActiveCertificationsForBuyer(Member buyer, Currency currency) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = HibernateHelper.getInitialQuery(this.getEntityType(), "cert");
        HibernateHelper.addParameterToQuery(hql, namedParameters, "cert.buyer", buyer);
        HibernateHelper.addParameterToQuery(hql, namedParameters, "cert.status", Certification.Status.ACTIVE);
        HibernateHelper.addParameterToQuery(hql, namedParameters, "cert.guaranteeType.currency", currency);
        return this.list(hql.toString(), namedParameters);
    }

    @Override
    public BigDecimal getUsedAmount(Certification certification) throws DaoException {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder("SELECT SUM(g.amount) FROM Guarantee g WHERE 1=1");
        HibernateHelper.addParameterToQuery(hql, namedParameters, "g.certification", certification);
        HibernateHelper.addParameterToQuery(hql, namedParameters, "g.status", Guarantee.Status.ACCEPTED);
        return (BigDecimal)this.uniqueResult(hql.toString(), namedParameters);
    }

    @Override
    public List<Certification> seach(CertificationQuery queryParameters) throws DaoException {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = HibernateHelper.getInitialQuery(this.getEntityType(), "cert", queryParameters.getFetch());
        if (queryParameters.getViewer() != null) {
            hql.append("and (cert.buyer = :viewer or cert.issuer = :viewer) ");
            namedParameters.put("viewer", queryParameters.getViewer());
        }
        HibernateHelper.addInParameterToQuery(hql, namedParameters, "cert.status", queryParameters.getStatusList());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "cert.buyer", queryParameters.getBuyer());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "cert.issuer", queryParameters.getIssuer());
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "cert.validity.begin", queryParameters.getStartIn());
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "cert.validity.end", queryParameters.getEndIn());
        if (CollectionUtils.isNotEmpty(queryParameters.getManagedMemberGroups())) {
            hql.append(" and (cert.buyer.group in (:groups_) and cert.issuer.group in (:groups_))");
            namedParameters.put("groups_", queryParameters.getManagedMemberGroups());
        }
        HibernateHelper.appendOrder(hql, "cert.validity.end asc");
        return this.list(queryParameters, hql.toString(), namedParameters);
    }
}

