/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.accounts.guarantees;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.accounts.guarantees.GuaranteeDAO;
import nl.strohalm.cyclos.entities.accounts.guarantees.Guarantee;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeQuery;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeType;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.utils.hibernate.HibernateCustomFieldHandler;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import org.apache.commons.collections.CollectionUtils;

public class GuaranteeDAOImpl
extends BaseDAOImpl<Guarantee>
implements GuaranteeDAO {
    private HibernateCustomFieldHandler hibernateCustomFieldHandler;

    public GuaranteeDAOImpl() {
        super(Guarantee.class);
    }

    @Override
    public Collection<MemberGroup> getBuyers(Group seller) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = HibernateHelper.getInitialQuery(Group.class, "buyer");
        HibernateHelper.addInElementsParameter(hql, namedParameters, "buyer.canBuyWithPaymentObligationsFromGroups", seller);
        return this.list(hql.toString(), namedParameters);
    }

    @Override
    public Collection<MemberGroup> getIssuers(GuaranteeType guaranteeType) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = HibernateHelper.getInitialQuery(Group.class, "issuer");
        HibernateHelper.addInElementsParameter(hql, namedParameters, "issuer.guaranteeTypes", guaranteeType);
        return this.list(hql.toString(), namedParameters);
    }

    @Override
    public Collection<GuaranteeType.Model> getRelatedGuaranteeModels(Member member) throws DaoException {
        HashMap<String, Member> namedParameters = new HashMap<String, Member>();
        namedParameters.put("member_", member);
        String hql = "select distinct(g.guaranteeType.model) from Guarantee g where g.issuer = :member_ or g.seller = :member_ or g.buyer = :member_";
        return this.list("select distinct(g.guaranteeType.model) from Guarantee g where g.issuer = :member_ or g.seller = :member_ or g.buyer = :member_", namedParameters);
    }

    @Override
    public Collection<MemberGroup> getSellers(Group issuer) {
        HashMap<String, Group> namedParameters = new HashMap<String, Group>();
        namedParameters.put("issuer_", issuer);
        StringBuilder hql = new StringBuilder("select distinct(seller) from Group seller, Group buyer, Group issuer where buyer in elements(issuer.canIssueCertificationToGroups) and seller in elements(buyer.canBuyWithPaymentObligationsFromGroups) and issuer = :issuer_");
        return this.list(hql.toString(), namedParameters);
    }

    @Override
    public Guarantee loadFromTransfer(Transfer rootTransfer) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = HibernateHelper.getInitialQuery(this.getEntityType(), "g");
        HibernateHelper.addParameterToQuery(hql, namedParameters, "g.loan.transfer", rootTransfer);
        return (Guarantee)this.uniqueResult(hql.toString(), namedParameters);
    }

    @Override
    public List<Guarantee> search(GuaranteeQuery queryParameters) throws DaoException {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder();
        hql.append(" select g");
        hql.append(" from ").append(this.getEntityType().getName()).append(" g ");
        this.hibernateCustomFieldHandler.appendJoins(hql, "g.customValues", queryParameters.getCustomValues());
        HibernateHelper.appendJoinFetch(hql, this.getEntityType(), "g", queryParameters.getFetch());
        hql.append(" left join g.buyer buyer left join g.seller seller ");
        hql.append(" where 1=1");
        HibernateHelper.addInParameterToQuery(hql, namedParameters, "g.status", queryParameters.getStatusList());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "g.issuer", queryParameters.getIssuer());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "g.buyer", queryParameters.getBuyer());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "g.seller", queryParameters.getSeller());
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "g.validity.begin", queryParameters.getStartIn());
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "g.validity.end", queryParameters.getEndIn());
        HibernateHelper.addParameterToQueryOperator(hql, namedParameters, "g.amount", ">=", queryParameters.getAmountLowerLimit());
        HibernateHelper.addParameterToQueryOperator(hql, namedParameters, "g.amount", "<=", queryParameters.getAmountUpperLimit());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "g.certification", queryParameters.getCertification());
        if (queryParameters.getGuaranteeType() != null) {
            HibernateHelper.addParameterToQuery(hql, namedParameters, "g.guaranteeType", queryParameters.getGuaranteeType());
        } else {
            HibernateHelper.addInParameterToQuery(hql, namedParameters, "g.guaranteeType", queryParameters.getAllowedGuaranteeTypes());
        }
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "g.registrationDate", queryParameters.getRegisteredIn());
        if (queryParameters.getLoanFilter() != null && queryParameters.getLoanFilter() != GuaranteeQuery.LoanFilter.ALL) {
            hql.append(" and g.loan is ");
            if (queryParameters.getLoanFilter() == GuaranteeQuery.LoanFilter.WITH_LOAN) {
                hql.append("not null");
            } else {
                hql.append("null");
            }
        }
        if (queryParameters.getLoggedMember() != null) {
            hql.append(" and (g.buyer = :logged_ or g.seller = :logged_)");
            namedParameters.put("logged_", queryParameters.getLoggedMember());
        }
        if (queryParameters.getMember() != null) {
            hql.append(" and (g.buyer = :member_ or g.seller = :member_)");
            namedParameters.put("member_", queryParameters.getMember());
        }
        this.hibernateCustomFieldHandler.appendConditions(hql, namedParameters, queryParameters.getCustomValues());
        if (queryParameters.isWithBuyerOnly()) {
            HibernateHelper.addParameterToQuery(hql, namedParameters, "g.guaranteeType.model", GuaranteeType.Model.WITH_BUYER_ONLY);
        }
        if (CollectionUtils.isNotEmpty(queryParameters.getManagedMemberGroups())) {
            hql.append(" and (buyer.group in (:groups_) and (seller is null or seller.group in (:groups_)))");
            namedParameters.put("groups_", queryParameters.getManagedMemberGroups());
        }
        HibernateHelper.appendOrder(hql, "g.id desc");
        return this.list(queryParameters, hql.toString(), namedParameters);
    }

    public void setHibernateCustomFieldHandler(HibernateCustomFieldHandler hibernateCustomFieldHandler) {
        this.hibernateCustomFieldHandler = hibernateCustomFieldHandler;
    }
}

