/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.accounts.guarantees;

import java.util.HashMap;
import java.util.List;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.accounts.guarantees.PaymentObligationDAO;
import nl.strohalm.cyclos.entities.accounts.guarantees.PaymentObligation;
import nl.strohalm.cyclos.entities.accounts.guarantees.PaymentObligationQuery;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import org.apache.commons.collections.CollectionUtils;

public class PaymentObligationDAOImpl
extends BaseDAOImpl<PaymentObligation>
implements PaymentObligationDAO {
    public PaymentObligationDAOImpl() {
        super(PaymentObligation.class);
    }

    @Override
    public List<PaymentObligation> loadOrderedByExpiration(Long ... ids) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder("SELECT po FROM PaymentObligation po where 1=1");
        HibernateHelper.addInParameterToQuery(hql, namedParameters, "po.id", ids);
        HibernateHelper.appendOrder(hql, "po.expirationDate");
        return this.list(hql.toString(), namedParameters);
    }

    @Override
    public List<PaymentObligation> search(PaymentObligationQuery queryParameters) throws DaoException {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = HibernateHelper.getInitialQuery(this.getEntityType(), "po", queryParameters.getFetch());
        HibernateHelper.addInParameterToQuery(hql, namedParameters, "po.status", queryParameters.getStatusList());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "po.buyer", queryParameters.getBuyer());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "po.currency", queryParameters.getCurrency());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "po.seller", queryParameters.getSeller());
        HibernateHelper.addParameterToQueryOperator(hql, namedParameters, "po.amount", ">=", queryParameters.getAmountLowerLimit());
        HibernateHelper.addParameterToQueryOperator(hql, namedParameters, "po.amount", "<=", queryParameters.getAmountUpperLimit());
        if (queryParameters.isApplyExpirationToMaxPublishDate()) {
            StringBuilder tmp1 = new StringBuilder("1=1");
            StringBuilder tmp2 = new StringBuilder("1=1");
            HibernateHelper.addPeriodParameterToQuery(tmp1, namedParameters, "po.expirationDate", queryParameters.getExpiration());
            HibernateHelper.addPeriodParameterToQuery(tmp2, namedParameters, "po.maxPublishDate", queryParameters.getExpiration());
            hql.append(" and (").append((CharSequence)tmp1).append(" or ").append((CharSequence)tmp2).append(")");
        } else {
            HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "po.expirationDate", queryParameters.getExpiration());
        }
        if (queryParameters.getLoggedMember() != null) {
            hql.append(" and ((po.buyer = :logged_ OR po.seller = :logged_) and not (po.status = :registeredStatus and po.buyer <> :logged_))");
            namedParameters.put("logged_", queryParameters.getLoggedMember());
            namedParameters.put("registeredStatus", PaymentObligation.Status.REGISTERED);
        }
        if (CollectionUtils.isNotEmpty(queryParameters.getManagedMemberGroups())) {
            hql.append(" and (po.buyer.group in (:groups_) and po.seller.group in (:groups_))");
            namedParameters.put("groups_", queryParameters.getManagedMemberGroups());
        }
        HibernateHelper.appendOrder(hql, "po.expirationDate");
        return this.list(queryParameters, hql.toString(), namedParameters);
    }
}

