/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.accounts.loans;

import java.util.HashMap;
import java.util.List;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.accounts.loans.LoanDAO;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.loans.LoanPayment;
import nl.strohalm.cyclos.entities.accounts.loans.LoanQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.hibernate.HibernateCustomFieldHandler;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;

public class LoanDAOImpl
extends BaseDAOImpl<Loan>
implements LoanDAO {
    private HibernateCustomFieldHandler hibernateCustomFieldHandler;

    public LoanDAOImpl() {
        super(Loan.class);
    }

    @Override
    public Loan getByTransfer(Transfer transfer) {
        HashMap<String, Transfer> params = new HashMap<String, Transfer>();
        StringBuilder hql = new StringBuilder();
        hql.append(" from Loan l ");
        hql.append(" where 1=1 ");
        hql.append(" and l.transfer = :transfer ");
        params.put("transfer", transfer);
        return (Loan)this.uniqueResult(hql.toString(), params);
    }

    public HibernateCustomFieldHandler getHibernateCustomFieldHandler() {
        return this.hibernateCustomFieldHandler;
    }

    @Override
    public List<Loan> search(LoanQuery query) {
        Period paymentPeriod;
        Member member;
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        namedParameters.put("openPaymentStatus", LoanPayment.Status.OPEN);
        namedParameters.put("expiredPaymentStatus", LoanPayment.Status.EXPIRED);
        namedParameters.put("repaidPaymentStatus", LoanPayment.Status.REPAID);
        namedParameters.put("discardedPaymentStatus", LoanPayment.Status.DISCARDED);
        namedParameters.put("inProcessPaymentStatus", LoanPayment.Status.IN_PROCESS);
        namedParameters.put("recoveredPaymentStatus", LoanPayment.Status.RECOVERED);
        namedParameters.put("unrecoverablePaymentStatus", LoanPayment.Status.UNRECOVERABLE);
        namedParameters.put("pendingStatus", Payment.Status.PENDING);
        namedParameters.put("deniedStatus", Payment.Status.DENIED);
        StringBuilder hql = new StringBuilder();
        hql.append(" select l ");
        hql.append(" from Loan l inner join l.transfer t ");
        this.hibernateCustomFieldHandler.appendJoins(hql, "t.customValues", query.getLoanCustomValues());
        HibernateHelper.appendJoinFetch(hql, this.getEntityType(), "l", query.getFetch());
        hql.append(", MemberAccount a inner join a.member m ");
        this.hibernateCustomFieldHandler.appendJoins(hql, "m.customValues", query.getMemberCustomValues());
        hql.append(" where t.to = a ");
        if (query.getStatus() != null) {
            LoanQuery.QueryStatus queryStatus = null;
            switch (query.getStatus()) {
                case OPEN: {
                    queryStatus = LoanQuery.QueryStatus.ANY_OPEN;
                    break;
                }
                case CLOSED: {
                    queryStatus = LoanQuery.QueryStatus.ANY_CLOSED;
                    break;
                }
                case PENDING_AUTHORIZATION: {
                    queryStatus = LoanQuery.QueryStatus.PENDING_AUTHORIZATION;
                    break;
                }
                case AUTHORIZATION_DENIED: {
                    queryStatus = LoanQuery.QueryStatus.AUTHORIZATION_DENIED;
                }
            }
            query.setQueryStatus(queryStatus);
            query.setStatus(null);
        }
        if (query.getQueryStatus() != null) {
            switch (query.getQueryStatus()) {
                case OPEN: {
                    hql.append(" and not exists (select lp.id from l.payments lp where lp.status in (:expiredPaymentStatus, :inProcessPaymentStatus, :recoveredPaymentStatus, :unrecoverablePaymentStatus))");
                    hql.append(" and exists (select lp.id from l.payments lp where lp.status = :openPaymentStatus)");
                    hql.append(" and t.processDate is not null");
                    break;
                }
                case ANY_OPEN: 
                case ANY_CLOSED: {
                    String condition = query.getQueryStatus() == LoanQuery.QueryStatus.ANY_CLOSED ? " and not " : " and ";
                    hql.append(condition + "exists (select lp.id from l.payments lp where lp.status in (:openPaymentStatus, :expiredPaymentStatus, :inProcessPaymentStatus))");
                    hql.append(" and t.processDate is not null");
                    break;
                }
                case CLOSED: {
                    hql.append(" and not exists (select lp.id from l.payments lp where lp.status in (:openPaymentStatus, :expiredPaymentStatus, :inProcessPaymentStatus, :recoveredPaymentStatus, :unrecoverablePaymentStatus))");
                    break;
                }
                case PENDING_AUTHORIZATION: {
                    hql.append(" and t.status = :pendingStatus");
                    break;
                }
                case AUTHORIZATION_DENIED: {
                    hql.append(" and t.status = :deniedStatus");
                    break;
                }
                case EXPIRED: {
                    hql.append(" and exists (select lp.id from l.payments lp where lp.status = :expiredPaymentStatus)");
                    break;
                }
                case IN_PROCESS: {
                    hql.append(" and exists (select lp.id from l.payments lp where lp.status = :inProcessPaymentStatus)");
                    break;
                }
                case RECOVERED: {
                    hql.append(" and exists (select lp.id from l.payments lp where lp.status = :recoveredPaymentStatus)");
                    break;
                }
                case UNRECOVERABLE: {
                    hql.append(" and exists (select lp.id from l.payments lp where lp.status = :unrecoverablePaymentStatus)");
                }
            }
        }
        if (query.isHideAuthorizationRelated()) {
            hql.append(" and t.status not in (:pendingStatus, :deniedStatus)");
        }
        if ((member = query.getMember()) != null) {
            member = this.getFetchDao().fetch(member, Element.Relationships.GROUP);
            MemberGroup group = member.getMemberGroup();
            if (group.getMemberSettings().isViewLoansByGroup()) {
                hql.append(" and (a.member = :member or :member in elements(l.toMembers))");
                namedParameters.put("member", member);
            } else {
                HibernateHelper.addParameterToQuery(hql, namedParameters, "a.member", member);
            }
        }
        HibernateHelper.addParameterToQuery(hql, namedParameters, "a.member.broker", query.getBroker());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "l.loanGroup", query.getLoanGroup());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "t.status", query.getTransferStatus());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "t.type", query.getTransferType());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "t.to.type", query.getAccountType());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "t.to.type.currency", query.getCurrency());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "t.transactionNumber", query.getTransactionNumber());
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "t.date", query.getGrantPeriod());
        Period expirationPeriod = query.getExpirationPeriod();
        if (expirationPeriod != null && (expirationPeriod.getBegin() != null || expirationPeriod.getEnd() != null)) {
            hql.append(" and exists (select lp.id from l.payments lp where (lp.status = :openPaymentStatus or lp.status = :expiredPaymentStatus) ");
            HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "lp.expirationDate", expirationPeriod);
            hql.append(')');
        }
        if ((paymentPeriod = query.getPaymentPeriod()) != null && (paymentPeriod.getBegin() != null || paymentPeriod.getEnd() != null)) {
            hql.append(" and exists (select lp.id from l.payments lp where (lp.status = :repaidPaymentStatus or lp.status = :discardedPaymentStatus) ");
            HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "lp.repaymentDate", paymentPeriod);
            hql.append(')');
        }
        if (query.getGroups() != null && !query.getGroups().isEmpty()) {
            hql.append(" and a.member.group in (:groups) ");
            namedParameters.put("groups", query.getGroups());
        }
        this.hibernateCustomFieldHandler.appendConditions(hql, namedParameters, query.getMemberCustomValues());
        this.hibernateCustomFieldHandler.appendConditions(hql, namedParameters, query.getLoanCustomValues());
        return this.list(query, hql.toString(), namedParameters);
    }

    public void setHibernateCustomFieldHandler(HibernateCustomFieldHandler hibernateCustomFieldHandler) {
        this.hibernateCustomFieldHandler = hibernateCustomFieldHandler;
    }
}

