/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.accounts.loans;

import java.util.HashMap;
import java.util.List;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.accounts.loans.LoanGroupDAO;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.loans.LoanGroup;
import nl.strohalm.cyclos.entities.accounts.loans.LoanGroupQuery;
import nl.strohalm.cyclos.utils.hibernate.HibernateCustomFieldHandler;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;

public class LoanGroupDAOImpl
extends BaseDAOImpl<LoanGroup>
implements LoanGroupDAO {
    private HibernateCustomFieldHandler hibernateCustomFieldHandler;

    public LoanGroupDAOImpl() {
        super(LoanGroup.class);
    }

    @Override
    public List<LoanGroup> search(LoanGroupQuery query) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder();
        hql.append(" select lg");
        hql.append(" from ").append(this.getEntityType().getName()).append(" lg ");
        this.hibernateCustomFieldHandler.appendJoins(hql, "lg.customValues", query.getCustomValues());
        HibernateHelper.appendJoinFetch(hql, this.getEntityType(), "lg", query.getFetch());
        hql.append(" where 1=1");
        HibernateHelper.addLikeParameterToQuery(hql, namedParameters, "lg.description", query.getDescription());
        HibernateHelper.addLikeParameterToQuery(hql, namedParameters, "lg.name", query.getName());
        if (query.getMember() != null) {
            if (query.isNotOfMember()) {
                hql.append(" and :notMember not in elements(lg.members) ");
            } else {
                hql.append(" and (:member in elements(lg.members) or exists ( ");
                hql.append("     select 1 from Member m where m.broker = :member and m in elements(lg.members) ");
                hql.append("))");
            }
            namedParameters.put("member", query.getMember());
        }
        if (query.getNoLoans() != null) {
            if (query.getNoLoans().booleanValue()) {
                hql.append(" and not exists (select 1 from " + Loan.class.getName() + " l where l.loanGroup = lg) ");
            } else {
                hql.append(" and exists (select 1 from " + Loan.class.getName() + " l where l.loanGroup = lg) ");
            }
        }
        this.hibernateCustomFieldHandler.appendConditions(hql, namedParameters, query.getCustomValues());
        HibernateHelper.appendOrder(hql, "lg.name");
        return this.list(query, hql.toString(), namedParameters);
    }

    public void setHibernateCustomFieldHandler(HibernateCustomFieldHandler hibernateCustomFieldHandler) {
        this.hibernateCustomFieldHandler = hibernateCustomFieldHandler;
    }
}

