/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.accounts.loans;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.accounts.loans.LoanPaymentDAO;
import nl.strohalm.cyclos.entities.accounts.loans.LoanPayment;
import nl.strohalm.cyclos.entities.accounts.loans.LoanPaymentQuery;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.services.transactions.TransactionSummaryVO;
import nl.strohalm.cyclos.utils.hibernate.HibernateCustomFieldHandler;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;

public class LoanPaymentDAOImpl
extends BaseDAOImpl<LoanPayment>
implements LoanPaymentDAO {
    private HibernateCustomFieldHandler hibernateCustomFieldHandler;

    public LoanPaymentDAOImpl() {
        super(LoanPayment.class);
    }

    public HibernateCustomFieldHandler getHibernateCustomFieldHandler() {
        return this.hibernateCustomFieldHandler;
    }

    @Override
    public TransactionSummaryVO paymentsSummary(LoanPaymentQuery query) throws DaoException {
        LoanPayment.Status status = query.getStatus();
        String amountPath = null;
        amountPath = status == LoanPayment.Status.REPAID ? "lp.repaidAmount" : "lp.amount - lp.repaidAmount";
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder();
        hql.append("select new " + TransactionSummaryVO.class.getName() + "(count(lp.id), sum(" + amountPath + "))");
        this.buildQuery(query, namedParameters, hql);
        return (TransactionSummaryVO)this.uniqueResult(hql.toString(), namedParameters);
    }

    @Override
    public List<LoanPayment> search(LoanPaymentQuery query) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder();
        hql.append("select lp");
        this.buildQuery(query, namedParameters, hql);
        HibernateHelper.appendOrder(hql, "lp.expirationDate");
        return this.list(query, hql.toString(), namedParameters);
    }

    public void setHibernateCustomFieldHandler(HibernateCustomFieldHandler hibernateCustomFieldHandler) {
        this.hibernateCustomFieldHandler = hibernateCustomFieldHandler;
    }

    private void buildQuery(LoanPaymentQuery query, Map<String, Object> namedParameters, StringBuilder hql) {
        hql.append(" from LoanPayment lp inner join lp.loan l inner join l.transfer t");
        this.hibernateCustomFieldHandler.appendJoins(hql, "t.customValues", query.getLoanCustomValues());
        HibernateHelper.appendJoinFetch(hql, this.getEntityType(), "lp", query.getFetch());
        hql.append(", MemberAccount a inner join a.member m ");
        this.hibernateCustomFieldHandler.appendJoins(hql, "m.customValues", query.getMemberCustomValues());
        hql.append(" where t.to = a ");
        HibernateHelper.addInParameterToQuery(hql, namedParameters, "lp.status", query.getStatusList());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "a.member", query.getMember());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "a.member.broker", query.getBroker());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "l.loanGroup", query.getLoanGroup());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "t.type", query.getTransferType());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "t.status", query.getTransferStatus());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "t.to.type", query.getAccountType());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "t.transactionNumber", query.getTransactionNumber());
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "lp.expirationDate", query.getExpirationPeriod());
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "lp.repaymentDate", query.getRepaymentPeriod());
        if (query.getGroups() != null && !query.getGroups().isEmpty()) {
            hql.append(" and a.member.group in (:groups) ");
            namedParameters.put("groups", query.getGroups());
        }
        this.hibernateCustomFieldHandler.appendConditions(hql, namedParameters, query.getMemberCustomValues());
        this.hibernateCustomFieldHandler.appendConditions(hql, namedParameters, query.getLoanCustomValues());
    }
}

