/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.accounts.pos;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.accounts.pos.PosDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.pos.MemberPos;
import nl.strohalm.cyclos.entities.accounts.pos.Pos;
import nl.strohalm.cyclos.entities.accounts.pos.PosQuery;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import org.apache.commons.lang.StringUtils;

public class PosDAOImpl
extends BaseDAOImpl<Pos>
implements PosDAO {
    public PosDAOImpl() {
        super(Pos.class);
    }

    @Override
    public List<Pos> getAllMemberPos(Member member) {
        HashMap<String, Member> namedParameters = new HashMap<String, Member>();
        StringBuilder hql = new StringBuilder("select p from " + this.getEntityType().getName() + " p");
        hql.append(" left join p.memberPos mp  ");
        hql.append(" where mp.member=:member");
        namedParameters.put("member", member);
        return this.list(hql.toString(), namedParameters);
    }

    @Override
    public Pos loadByPosId(String posId, Relationship ... fetch) throws EntityNotFoundException {
        if (!StringUtils.isEmpty((String)posId)) {
            HashMap<String, Object> namedParameters = new HashMap<String, Object>();
            StringBuilder hql = new StringBuilder("select p from " + this.getEntityType().getName() + " p");
            hql.append(" where 1 = 1");
            HibernateHelper.addParameterToQuery(hql, namedParameters, "p.posId", posId);
            Pos pos = (Pos)this.uniqueResult(hql.toString(), namedParameters);
            if (pos == null) {
                throw new EntityNotFoundException(Pos.class);
            }
            return this.getFetchDao().fetch(pos, fetch);
        }
        throw new EntityNotFoundException(Pos.class);
    }

    @Override
    public List<Pos> search(PosQuery query) throws DaoException {
        ArrayList<Pos.Status> posStatuses = new ArrayList<Pos.Status>();
        ArrayList<MemberPos.Status> memberPosStatuses = new ArrayList<MemberPos.Status>();
        Collection<PosQuery.QueryStatus> statuses = query.getStatuses();
        if (statuses != null) {
            for (PosQuery.QueryStatus status : statuses) {
                if (status.getPosStatus() != null) {
                    posStatuses.add(status.getPosStatus());
                    continue;
                }
                memberPosStatuses.add(status.getMemberPosStatus());
            }
        }
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder("select p from " + this.getEntityType().getName() + " p");
        hql.append(" left join p.memberPos mp");
        hql.append(" left join mp.member m");
        hql.append(" left join m.group g");
        hql.append(" where 1 = 1");
        HibernateHelper.addParameterToQuery(hql, namedParameters, "p.posId", query.getPosId());
        if (!posStatuses.isEmpty() && !memberPosStatuses.isEmpty()) {
            hql.append(" and (p.status in (:posStatuses) or (mp.status in (:memberPosStatuses)))");
            namedParameters.put("posStatuses", posStatuses);
            namedParameters.put("memberPosStatuses", memberPosStatuses);
        } else if (posStatuses.isEmpty() && !memberPosStatuses.isEmpty()) {
            HibernateHelper.addInParameterToQuery(hql, namedParameters, "mp.status", memberPosStatuses);
        } else if (!posStatuses.isEmpty() && memberPosStatuses.isEmpty()) {
            HibernateHelper.addInParameterToQuery(hql, namedParameters, "p.status", posStatuses);
        }
        HibernateHelper.addParameterToQuery(hql, namedParameters, "mp.member", query.getMember());
        if (query.getBroker() != null) {
            hql.append(" and (m.broker = :broker or p.memberPos is null or p.status = :status) ");
            namedParameters.put("status", Pos.Status.UNASSIGNED);
            namedParameters.put("broker", query.getBroker());
        }
        if (query.getManagedBy() != null) {
            hql.append(" and( p.memberPos is null or p.status = :status or   g in (select mg from AdminGroup ag join ag.managesGroups mg where ag = :managedBy)) ");
            namedParameters.put("managedBy", query.getManagedBy());
        }
        HibernateHelper.appendOrder(hql, "p.posId", "m.name");
        return this.list(query, hql.toString(), namedParameters);
    }
}

