/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.accounts.transactions;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.accounts.transactions.InvoiceDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.transactions.Invoice;
import nl.strohalm.cyclos.entities.accounts.transactions.InvoiceQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.InvoiceSummaryDTO;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.reports.InvoiceSummaryType;
import nl.strohalm.cyclos.services.transactions.TransactionSummaryVO;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import org.apache.commons.collections.CollectionUtils;

public class InvoiceDAOImpl
extends BaseDAOImpl<Invoice>
implements InvoiceDAO {
    public InvoiceDAOImpl() {
        super(Invoice.class);
    }

    @Override
    public TransactionSummaryVO getSummary(InvoiceSummaryDTO dto) {
        InvoiceQuery.Direction direction = dto.getDirection();
        AccountOwner owner = dto.getOwner();
        AccountOwner relatedOwner = dto.getRelatedOwner();
        PaymentFilter filter = dto.getFilter();
        Period period = dto.getPeriod();
        Invoice.Status status = dto.getStatus();
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder("select new " + TransactionSummaryVO.class.getName() + "(count(*), sum(e.amount)) from " + this.getEntityType().getName() + " e ");
        hql.append(" where e." + (direction == InvoiceQuery.Direction.INCOMING ? "to" : "from") + "Member" + (owner instanceof SystemAccountOwner ? " is null " : " = :owner"));
        namedParameters.put("owner", owner);
        if (dto.getCurrency() != null) {
            hql.append(" and (exists (select tt.id from TransferType tt where tt = e.transferType and tt.from.currency = :currency) or exists (select at.id from AccountType at where at = e.destinationAccountType and at.currency = :currency))");
            namedParameters.put("currency", dto.getCurrency());
        }
        if (dto.isFromMemberToMember()) {
            hql.append(" and e." + (direction == InvoiceQuery.Direction.INCOMING ? "from" : "to") + "Member is not null");
        } else if (relatedOwner != null) {
            hql.append(" and e." + (direction == InvoiceQuery.Direction.INCOMING ? "from" : "to") + "Member" + (relatedOwner instanceof SystemAccountOwner ? " is null " : " = :relatedOwner"));
            namedParameters.put("relatedOwner", relatedOwner);
        }
        if (CollectionUtils.isNotEmpty(dto.getTypes())) {
            hql.append(" and ( ");
            hql.append("    e.destinationAccountType in (:types) or ");
            hql.append("    exists(select i.id from Invoice i where i.transferType.from in (:types) and i = e) or ");
            hql.append("    exists(select i.id from Invoice i where i.transferType.to in (:types) and i = e) ");
            hql.append(" ) ");
            namedParameters.put("types", dto.getTypes());
        }
        if (status != null) {
            hql.append(" and e.status = :status ");
            namedParameters.put("status", status);
        }
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "e.date", period);
        if (filter != null) {
            filter = this.getFetchDao().fetch(filter, PaymentFilter.Relationships.TRANSFER_TYPES);
            HibernateHelper.addInParameterToQuery(hql, namedParameters, "e.transferType", filter.getTransferTypes());
        }
        return (TransactionSummaryVO)this.uniqueResult(hql.toString(), namedParameters);
    }

    @Override
    public TransactionSummaryVO getSummaryByType(Currency currency, InvoiceSummaryType invoiceSummaryType, Collection<MemberGroup> memberGroups) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        String fromMember = " is not null ";
        String toMember = " is not null ";
        switch (invoiceSummaryType) {
            case SYSTEM_INCOMING: {
                toMember = " is null ";
                break;
            }
            case SYSTEM_OUTGOING: {
                fromMember = " is null ";
            }
        }
        StringBuilder hql = new StringBuilder("select new " + TransactionSummaryVO.class.getName() + "(count(*), sum(i.amount)) from Invoice i ");
        hql.append(" where i.fromMember " + fromMember + " and i.toMember " + toMember);
        hql.append(" and (exists (select tt.id from TransferType tt where tt = i.transferType and tt.from.currency = :currency) or exists (select at.id from AccountType at where at = i.destinationAccountType and at.currency = :currency))");
        namedParameters.put("currency", currency);
        if (memberGroups != null && !memberGroups.isEmpty()) {
            switch (invoiceSummaryType) {
                case SYSTEM_INCOMING: {
                    hql.append(" and i.fromMember.group in (:memberGroups) ");
                    break;
                }
                case SYSTEM_OUTGOING: {
                    hql.append(" and i.toMember.group in (:memberGroups) ");
                    break;
                }
                case MEMBER: {
                    hql.append(" and (i.fromMember.group in (:memberGroups) or i.toMember.group in (:memberGroups)) ");
                }
            }
            namedParameters.put("memberGroups", memberGroups);
        }
        namedParameters.put("status", Invoice.Status.OPEN);
        hql.append(" and i.status = :status");
        return (TransactionSummaryVO)this.uniqueResult(hql.toString(), namedParameters);
    }

    @Override
    public Invoice loadByPayment(Payment payment, Relationship ... fetch) throws EntityNotFoundException {
        String property = payment instanceof Transfer ? "transfer" : "scheduledPayment";
        Map<String, Payment> params = Collections.singletonMap("payment", payment);
        Invoice invoice = (Invoice)this.uniqueResult("from Invoice i where i." + property + " = :payment", params);
        if (invoice == null) {
            throw new EntityNotFoundException(this.getEntityType());
        }
        return this.getFetchDao().fetch(invoice, fetch);
    }

    @Override
    public List<Invoice> search(InvoiceQuery query) {
        String related;
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        Set<Relationship> fetch = query.getFetch();
        StringBuilder hql = new StringBuilder("select i from " + this.getEntityType().getName() + " i");
        hql.append(" left join i.fromMember fm");
        hql.append(" left join fm.group fmg");
        hql.append(" left join i.toMember tm");
        hql.append(" left join tm.group tmg");
        HibernateHelper.appendJoinFetch(hql, this.getEntityType(), "i", fetch);
        hql.append(" where 1 = 1");
        HibernateHelper.addLikeParameterToQuery(hql, namedParameters, "i.description", query.getDescription());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "i.status", query.getStatus());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "i.transferType", query.getTransferType());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "i.transfer.transactionNumber", query.getTransactionNumber());
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "i.date", query.getPeriod());
        if (query.getPaymentPeriod() != null) {
            hql.append(" and exists (select ip.id from InvoicePayment ip where ip.invoice = i");
            HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "ip.date", query.getPaymentPeriod());
            hql.append(" ) ");
        }
        boolean isIncoming = query.getDirection() == InvoiceQuery.Direction.INCOMING;
        String owner = isIncoming ? "to" : "from";
        String string = related = isIncoming ? "from" : "to";
        if (query.getOwner() != null) {
            if (query.getOwner() instanceof SystemAccountOwner) {
                hql.append(" and i." + owner + "Member is null ");
            } else {
                HibernateHelper.addParameterToQuery(hql, namedParameters, "i." + owner + "Member", query.getOwner());
            }
        }
        if (query.getRelatedOwner() != null) {
            if (query.getRelatedOwner() instanceof SystemAccountOwner) {
                hql.append(" and i." + related + "Member is null ");
            } else {
                HibernateHelper.addParameterToQuery(hql, namedParameters, "i." + related + "Member", query.getRelatedOwner());
            }
        }
        if (query.getGroups() != null && !query.getGroups().isEmpty()) {
            hql.append(" and (fmg in (:groups) or tmg in (:groups)) ");
            namedParameters.put("groups", query.getGroups());
        }
        if (query.getBy() != null) {
            hql.append(" and (i.performedBy = :by or i.sentBy = :by)");
            namedParameters.put("by", query.getBy());
        }
        HibernateHelper.appendOrder(hql, "i.date desc");
        return this.list(query, hql.toString(), namedParameters);
    }
}

