/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.accounts.transactions;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.accounts.transactions.PaymentFilterDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.MemberGroupAccountSettings;
import nl.strohalm.cyclos.entities.accounts.SystemAccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilterQuery;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import org.apache.commons.collections.CollectionUtils;

public class PaymentFilterDAOImpl
extends BaseDAOImpl<PaymentFilter>
implements PaymentFilterDAO {
    public PaymentFilterDAOImpl() {
        super(PaymentFilter.class);
    }

    @Override
    public List<PaymentFilter> search(PaymentFilterQuery query) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        Set<Relationship> fetch = query.getFetch();
        StringBuilder hql = HibernateHelper.getInitialQuery(this.getEntityType(), "pf", fetch);
        HibernateHelper.addLikeParameterToQuery(hql, namedParameters, "pf.description", query.getDescription());
        HibernateHelper.addLikeParameterToQuery(hql, namedParameters, "pf.name", query.getName());
        Collection<AccountType> accountTypes = query.getAccountTypes();
        Account ac = query.getAccount();
        if (CollectionUtils.isEmpty(accountTypes) && ac != null) {
            AccountType at = this.getFetchDao().fetch(ac, Account.Relationships.TYPE).getType();
            accountTypes = Collections.singletonList(at);
        }
        HibernateHelper.addInParameterToQuery(hql, namedParameters, "pf.accountType", accountTypes);
        if (query.getContext() == PaymentFilterQuery.Context.ACCOUNT_HISTORY) {
            hql.append(" and pf.showInAccountHistory = true ");
        }
        if (query.getContext() == PaymentFilterQuery.Context.REPORT) {
            hql.append(" and pf.showInReports = true ");
        }
        if (query.getElement() != null) {
            hql.append(" and exists (select e.id from ").append(Element.class.getName()).append(" e where e = :element and pf in elements(e.group.paymentFilters)) ");
            namedParameters.put("element", query.getElement());
        }
        if (!CollectionUtils.isEmpty(query.getMemberGroups())) {
            hql.append(" and exists (select mgas.id from ").append(MemberGroupAccountSettings.class.getName()).append(" mgas where mgas.group in (:memberGroups) and pf.accountType = mgas.accountType ) ");
            namedParameters.put("memberGroups", query.getMemberGroups());
        }
        if (query.getNature() != null) {
            Class clazz = SystemAccountType.class;
            if (query.getNature() == AccountType.Nature.MEMBER) {
                clazz = MemberAccountType.class;
            }
            hql.append(" and exists (select 1 from ").append(clazz.getName()).append(" nat where nat = pf.accountType) ");
        }
        HibernateHelper.appendOrder(hql, "pf.accountType.name", "pf.name");
        return this.list(query, hql.toString(), namedParameters);
    }
}

