/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.accounts.transactions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.accounts.AccountDAO;
import nl.strohalm.cyclos.dao.accounts.transactions.ScheduledPaymentDAO;
import nl.strohalm.cyclos.entities.accounts.AccountQuery;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPaymentQuery;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import org.apache.commons.collections.CollectionUtils;

public class ScheduledPaymentDAOImpl
extends BaseDAOImpl<ScheduledPayment>
implements ScheduledPaymentDAO {
    private AccountDAO accountDao;

    public ScheduledPaymentDAOImpl() {
        super(ScheduledPayment.class);
    }

    @Override
    public List<ScheduledPayment> getUnrelatedPendingPayments(Member member, Collection<MemberAccountType> accountTypes) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        namedParameters.put("_accountTypes_", accountTypes);
        namedParameters.put("_pending_", Arrays.asList(Payment.Status.PENDING, Payment.Status.SCHEDULED, Payment.Status.BLOCKED));
        namedParameters.put("_member_", member);
        StringBuilder hql = new StringBuilder("SELECT sp from ");
        hql.append(ScheduledPayment.class.getName()).append(" ");
        hql.append("sp WHERE sp.status in (:_pending_) ");
        if (accountTypes.isEmpty()) {
            hql.append("AND (sp.from.member = :_member_ OR sp.to.member = :_member_) ");
        } else {
            hql.append("AND (sp.from.member = :_member_ AND sp.from.type NOT IN (:_accountTypes_) OR sp.to.member = :_member_ AND sp.to.type NOT IN (:_accountTypes_)) ");
        }
        return this.list(hql.toString(), namedParameters);
    }

    @Override
    public List<ScheduledPayment> search(ScheduledPaymentQuery query) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = HibernateHelper.getInitialQuery(ScheduledPayment.class, "sp", query.getFetch());
        HibernateHelper.addInParameterToQuery(hql, namedParameters, "sp.status", query.getStatusList());
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "sp.date", query.getPeriod());
        List<Object> ownerAccounts = new ArrayList();
        AccountQuery accountQuery = new AccountQuery();
        accountQuery.setOwner(query.getOwner());
        if (query.getAccountType() != null) {
            accountQuery.setType(query.getAccountType());
        }
        if (CollectionUtils.isEmpty(ownerAccounts = this.accountDao.search(accountQuery))) {
            return Collections.emptyList();
        }
        namedParameters.put("ownerAccounts", ownerAccounts);
        List<Object> otherAccounts = new ArrayList();
        if (query.getMember() != null) {
            AccountQuery otherAccountsQuery = new AccountQuery();
            otherAccountsQuery.setOwner(query.getMember());
            otherAccounts = this.accountDao.search(otherAccountsQuery);
            if (CollectionUtils.isEmpty(otherAccounts)) {
                return Collections.emptyList();
            }
            namedParameters.put("otherAccounts", otherAccounts);
        }
        if (query.getSearchType() == ScheduledPaymentQuery.SearchType.OUTGOING) {
            hql.append(" and sp.from in (:ownerAccounts) ");
            if (CollectionUtils.isNotEmpty(otherAccounts)) {
                hql.append(" and sp.to in (:otherAccounts) ");
            }
        } else {
            hql.append(" and sp.to in (:ownerAccounts) ");
            if (CollectionUtils.isNotEmpty(otherAccounts)) {
                hql.append(" and sp.from in (:otherAccounts) ");
            }
            hql.append(" and sp.showToReceiver = true");
        }
        HibernateHelper.appendOrder(hql, "sp.date desc");
        return this.list(query, hql.toString(), namedParameters);
    }

    public void setAccountDao(AccountDAO accountDao) {
        this.accountDao = accountDao;
    }
}

