/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.accounts.transactions;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.accounts.transactions.TicketDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.transactions.Ticket;
import nl.strohalm.cyclos.entities.accounts.transactions.TicketQuery;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import org.apache.commons.lang.ArrayUtils;

public class TicketDAOImpl
extends BaseDAOImpl<Ticket>
implements TicketDAO {
    public TicketDAOImpl() {
        super(Ticket.class);
    }

    @Override
    public boolean exists(String ticket) {
        try {
            this.load(ticket, new Relationship[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public <T extends Ticket> T load(String value, Relationship ... fetch) {
        Map<String, String> params = Collections.singletonMap("ticket", value);
        Ticket ticket = (Ticket)this.uniqueResult("from " + this.getEntityType().getName() + " t where t.ticket = :ticket", params);
        if (ticket == null) {
            throw new EntityNotFoundException(Ticket.class);
        }
        if (ArrayUtils.isNotEmpty((Object[])fetch)) {
            ticket = this.getFetchDao().fetch(ticket, fetch);
        }
        return (T)ticket;
    }

    @Override
    public List<? extends Ticket> search(TicketQuery query) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = HibernateHelper.getInitialQuery(this.getEntityType(), "t", query.getFetch());
        if (query.getNature() != null) {
            HibernateHelper.addParameterToQuery(hql, namedParameters, "t.class", query.getNature().getValue());
        }
        HibernateHelper.addParameterToQuery(hql, namedParameters, "t.status", query.getStatus());
        if (query.getGroupedStatus() != null) {
            HibernateHelper.addInParameterToQuery(hql, namedParameters, "t.status", query.getGroupedStatus().getNormalStatus());
        }
        HibernateHelper.addParameterToQueryOperator(hql, namedParameters, "t.creationDate", "<", query.getCreatedBefore());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "t.from", query.getFrom());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "t.to", query.getTo());
        HibernateHelper.appendOrder(hql, "t.creationDate desc");
        return this.list(query, hql.toString(), namedParameters);
    }
}

