/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.accounts.transactions;

import java.util.Calendar;
import java.util.HashMap;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.accounts.transactions.TraceNumberDAO;
import nl.strohalm.cyclos.entities.accounts.transactions.TraceNumber;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;

public class TraceNumberDAOImpl
extends BaseDAOImpl<TraceNumber>
implements TraceNumberDAO {
    public TraceNumberDAOImpl() {
        super(TraceNumber.class);
    }

    @Override
    public void delete(Calendar upperBound) {
        String hql = "DELETE FROM TraceNumber t WHERE t.date <= :_date_";
        HashMap<String, Calendar> namedParameters = new HashMap<String, Calendar>();
        namedParameters.put("_date_", upperBound);
        this.bulkUpdate(hql, namedParameters);
    }

    @Override
    public TraceNumber load(Long clientId, String traceNumber) throws EntityNotFoundException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("clientId", clientId);
        parameters.put("traceNumber", traceNumber);
        TraceNumber tn = (TraceNumber)this.uniqueResult("from TraceNumber r where r.clientId = :clientId and r.traceNumber = :traceNumber", parameters);
        if (tn == null) {
            throw new EntityNotFoundException();
        }
        return tn;
    }
}

