/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.accounts.transactions;

import java.util.HashMap;
import java.util.List;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.accounts.transactions.TransferAuthorizationDAO;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferAuthorization;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferAuthorizationQuery;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;

public class TransferAuthorizationDAOImpl
extends BaseDAOImpl<TransferAuthorization>
implements TransferAuthorizationDAO {
    public TransferAuthorizationDAOImpl() {
        super(TransferAuthorization.class);
    }

    @Override
    public List<TransferAuthorization> search(TransferAuthorizationQuery query) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = HibernateHelper.getInitialQuery(this.getEntityType(), "a", query.getFetch());
        if (query.isByAdministration()) {
            hql.append(" and a.by.class = :admin");
            namedParameters.put("admin", Element.Nature.ADMIN.getValue());
        }
        if (query.getBy() != null) {
            hql.append(" and (a.by = :by or exists (select op.id from Operator op where op = a.by and op.member = :by))");
            namedParameters.put("by", query.getBy());
        }
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "a.date", query.getPeriod());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "a.action", query.getAction());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "a.transfer.type", query.getTransferType());
        if (query.getMember() != null) {
            hql.append(" and exists (select ma.id from MemberAccount ma where ma.member = :member and (ma = a.transfer.from or ma = a.transfer.to))");
            namedParameters.put("member", query.getMember());
        }
        HibernateHelper.appendOrder(hql, "a.date desc");
        return this.list(query, hql.toString(), namedParameters);
    }
}

