/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.accounts.transactions;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.List;
import nl.strohalm.cyclos.dao.BaseDAO;
import nl.strohalm.cyclos.dao.InsertableDAO;
import nl.strohalm.cyclos.dao.UpdatableDAO;
import nl.strohalm.cyclos.dao.accounts.transactions.SimpleTransferVO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.Rated;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransfer;
import nl.strohalm.cyclos.entities.accounts.transactions.AuthorizationLevel;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransfersAwaitingAuthorizationQuery;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.entities.reports.StatisticalDTO;
import nl.strohalm.cyclos.services.stats.general.KeyDevelopmentsStatsPerMonthVO;
import nl.strohalm.cyclos.utils.Pair;
import nl.strohalm.cyclos.utils.Period;

public interface TransferDAO
extends BaseDAO<Transfer>,
InsertableDAO<Transfer>,
UpdatableDAO<Transfer> {
    public BigDecimal balanceDiff(Account var1, Period var2);

    public BigDecimal balanceDiff(Account var1, Period var2, Transfer var3);

    public BigDecimal getChargebackBalance(Account var1, Period var2);

    public BigDecimal getChargebackBalance(Account var1, Transfer var2, boolean var3);

    public List<Pair<Member, BigDecimal>> getGrossProductPerMember(StatisticalDTO var1) throws DaoException;

    public List<KeyDevelopmentsStatsPerMonthVO> getGrossProductPerMonth(StatisticalDTO var1);

    public List<Pair<Member, Integer>> getNumberOfTransactionsPerMember(StatisticalDTO var1) throws DaoException;

    public List<KeyDevelopmentsStatsPerMonthVO> getNumberOfTransactionsPerMonth(StatisticalDTO var1);

    public Calendar getOldestTransfer(Currency var1, Account var2, Period var3, boolean var4);

    public List<Pair<Member, BigDecimal>> getPaymentsPerMember(StatisticalDTO var1) throws DaoException;

    public BigDecimal getSumOfTransactions(StatisticalDTO var1) throws DaoException;

    public BigDecimal getSumOfTransactionsRest(TransferQuery var1);

    public List<Number> getTransactionAmounts(StatisticalDTO var1);

    public BigDecimal getTransactionedAmountAt(Calendar var1, Account var2, TransferType var3);

    public BigDecimal getTransactionedAmountAt(Calendar var1, Operator var2, Account var3, TransferType var4);

    public List<Transfer> getTransfers(Currency var1, Account var2, Period var3, Transfer var4, boolean var5, Integer var6);

    public boolean hasTransfers(Account var1);

    public Transfer loadTransferByTraceNumber(String var1, Long var2, Relationship ... var3);

    public List<SimpleTransferVO> paymentVOs(Account var1, Period var2) throws DaoException;

    public List<Transfer> search(TransferQuery var1) throws DaoException;

    public List<Transfer> searchTransfersAwaitingAuthorization(TransfersAwaitingAuthorizationQuery var1);

    public Transfer updateAuthorizationData(Long var1, Payment.Status var2, AuthorizationLevel var3, Calendar var4, Rated var5);

    public Transfer updateChargeBack(Transfer var1, Transfer var2);

    public Transfer updateExternalTransfer(Long var1, ExternalTransfer var2);

    public Transfer updateStatus(Long var1, Payment.Status var2);

    public Transfer updateTransactionNumber(Long var1, String var2);
}

