/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.accounts.transactions;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.accounts.AccountDAO;
import nl.strohalm.cyclos.dao.accounts.transactions.SimpleTransferVO;
import nl.strohalm.cyclos.dao.accounts.transactions.TransferDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountQuery;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.Rated;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransfer;
import nl.strohalm.cyclos.entities.accounts.transactions.AuthorizationLevel;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransfersAwaitingAuthorizationQuery;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.entities.reports.StatisticalDTO;
import nl.strohalm.cyclos.services.stats.general.KeyDevelopmentsStatsPerMonthVO;
import nl.strohalm.cyclos.utils.BigDecimalHelper;
import nl.strohalm.cyclos.utils.Pair;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.hibernate.HibernateCustomFieldHandler;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import nl.strohalm.cyclos.utils.query.PageParameters;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.statistics.ListOperations;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;

public class TransferDAOImpl
extends BaseDAOImpl<Transfer>
implements TransferDAO {
    private AccountDAO accountDao;
    private HibernateCustomFieldHandler hibernateCustomFieldHandler;

    public TransferDAOImpl() {
        super(Transfer.class);
    }

    @Override
    public BigDecimal balanceDiff(Account account, Period period) {
        if (account == null) {
            return BigDecimal.ZERO;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("account", account.getId());
        StringBuilder hql = new StringBuilder();
        hql.append(" select sum( ");
        hql.append("     case when t.chargebackOf.id is null then ");
        hql.append("         case when t.from.id = :account then -t.amount else t.amount end ");
        hql.append("     else ");
        hql.append("         case when t.to.id = :account then t.amount else -t.amount end ");
        hql.append("     end)");
        hql.append(" from Transfer t ");
        hql.append(" where (t.from.id = :account or t.to.id = :account) ");
        hql.append("   and t.processDate is not null ");
        HibernateHelper.addPeriodParameterToQuery(hql, params, "t.processDate", period);
        BigDecimal diff = (BigDecimal)this.uniqueResult(hql.toString(), params);
        return BigDecimalHelper.nvl(diff);
    }

    @Override
    public BigDecimal balanceDiff(Account account, Period period, Transfer transfer) {
        if (account == null) {
            return BigDecimal.ZERO;
        }
        period = period.clone();
        period.setEnd(null);
        HashMap<String, Comparable<Long>> params = new HashMap<String, Comparable<Long>>();
        params.put("account", account.getId());
        StringBuilder hql = new StringBuilder();
        hql.append(" select sum( ");
        hql.append("     case when t.chargebackOf.id is null then ");
        hql.append("         case when t.from.id = :account then -t.amount else t.amount end ");
        hql.append("     else ");
        hql.append("         case when t.to.id = :account then t.amount else -t.amount end ");
        hql.append("     end)");
        hql.append(" from Transfer t ");
        hql.append(" where (t.from.id = :account or t.to.id = :account) ");
        hql.append("   and t.processDate is not null ");
        if (period != null && period.getBegin() != null) {
            hql.append("   and (t.processDate >");
            if (period.isInclusiveBegin()) {
                hql.append("=");
            }
            hql.append(" :beginDate ) ");
            params.put("beginDate", period.getBegin());
        }
        params.put("endDate", transfer.getProcessDate());
        params.put("transferId", transfer.getId());
        hql.append("   and (t.processDate < :endDate or (t.processDate = :endDate and t.id <");
        if (period != null && period.isInclusiveEnd()) {
            hql.append("=");
        }
        hql.append(" :transferId) ) ");
        BigDecimal diff = (BigDecimal)this.uniqueResult(hql.toString().trim(), params);
        return BigDecimalHelper.nvl(diff);
    }

    @Override
    public BigDecimal getChargebackBalance(Account account, Period period) {
        if (account == null) {
            return BigDecimal.ZERO;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("account", account.getId());
        StringBuilder hql = new StringBuilder();
        hql.append(" select sum(case when t.from.id = :account then t.amount else -t.amount end) ");
        hql.append(" from Transfer t ");
        hql.append(" where (t.from.id = :account or t.to.id = :account) ");
        hql.append(" and (t.chargedBackBy is not null or t.chargebackOf is not null) ");
        hql.append("   and t.processDate is not null ");
        HibernateHelper.addPeriodParameterToQuery(hql, params, "t.processDate", period);
        BigDecimal diff = (BigDecimal)this.uniqueResult(hql.toString(), params);
        return BigDecimalHelper.nvl(diff);
    }

    @Override
    public BigDecimal getChargebackBalance(Account account, Transfer transfer, boolean inclusive) {
        if (account == null) {
            return BigDecimal.ZERO;
        }
        HashMap<String, Comparable<Long>> params = new HashMap<String, Comparable<Long>>();
        params.put("account", account.getId());
        StringBuilder hql = new StringBuilder();
        hql.append(" select sum(case when t.from.id = :account then t.amount else -t.amount end) ");
        hql.append(" from Transfer t ");
        hql.append(" where (t.from.id = :account or t.to.id = :account) ");
        hql.append(" and (t.chargedBackBy is not null or t.chargebackOf is not null) ");
        hql.append("   and t.processDate is not null ");
        params.put("date", transfer.getProcessDate());
        params.put("transferId", transfer.getId());
        hql.append("   and (t.processDate < :date or (t.processDate = :date and t.id <");
        if (inclusive) {
            hql.append("=");
        }
        hql.append(" :transferId) ) ");
        BigDecimal diff = (BigDecimal)this.uniqueResult(hql.toString(), params);
        return BigDecimalHelper.nvl(diff);
    }

    @Override
    public List<Pair<Member, BigDecimal>> getGrossProductPerMember(StatisticalDTO dto) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder("select new " + Pair.class.getName());
        hql.append("(m, sum(t.amount)) from Transfer t, Member m where 1=1 ");
        hql.append(" and t.chargedBackBy is null and t.chargebackOf is null ");
        hql.append(" and exists (select ma.id from MemberAccount ma where t.to = ma and m = ma.member) ");
        this.appendGroupAndPaymentFilterAndPeriod(hql, namedParameters, dto);
        hql.append(" group by m ");
        hql.append(" order by sum(t.amount) desc ");
        return this.list(hql.toString(), namedParameters);
    }

    @Override
    public List<KeyDevelopmentsStatsPerMonthVO> getGrossProductPerMonth(StatisticalDTO dto) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder();
        hql.append(" select new " + KeyDevelopmentsStatsPerMonthVO.class.getName());
        hql.append(" (sum(t.amount), month(t.processDate), year(t.processDate)) ");
        hql.append(" from Transfer t, Member m where 1=1 ");
        hql.append(" and t.chargedBackBy is null and t.chargebackOf is null ");
        hql.append(" and exists (select ma.id from MemberAccount ma where t.to = ma and m = ma.member) ");
        this.appendGroupAndPaymentFilterAndPeriod(hql, namedParameters, dto);
        hql.append(" group by month(t.processDate), year(t.processDate) ");
        hql.append(" order by year(t.processDate), month(t.processDate) ");
        List<KeyDevelopmentsStatsPerMonthVO> list = this.list(hql.toString(), namedParameters);
        return list;
    }

    @Override
    public List<Pair<Member, Integer>> getNumberOfTransactionsPerMember(StatisticalDTO dto) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder();
        hql.append("select new " + Pair.class.getName() + "(m, count(t.id))");
        hql.append(" from Transfer t, Member m where 1=1 ");
        hql.append(" and t.chargedBackBy is null and t.chargebackOf is null ");
        hql.append(" and (exists (select ma.id from MemberAccount ma where t.to = ma and m = ma.member) ");
        hql.append(" or exists (select ma.id from MemberAccount ma where t.from = ma and m = ma.member)) ");
        this.appendGroupAndPaymentFilterAndPeriod(hql, namedParameters, dto);
        hql.append(" group by m ");
        hql.append(" order by count(t.id) desc ");
        return this.list(hql.toString(), namedParameters);
    }

    @Override
    public List<KeyDevelopmentsStatsPerMonthVO> getNumberOfTransactionsPerMonth(StatisticalDTO dto) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder();
        hql.append(" select new " + KeyDevelopmentsStatsPerMonthVO.class.getName());
        hql.append(" (count(distinct t.id), month(t.processDate), year(t.processDate)) ");
        hql.append(" from Transfer t, Member m where 1=1 ");
        hql.append(" and t.chargedBackBy is null and t.chargebackOf is null ");
        hql.append(" and (exists (select ma.id from MemberAccount ma where t.to = ma and m = ma.member) ");
        hql.append(" or exists (select ma.id from MemberAccount ma where t.from = ma and m = ma.member)) ");
        this.appendGroupAndPaymentFilterAndPeriod(hql, namedParameters, dto);
        hql.append(" group by month(t.processDate), year(t.processDate) ");
        hql.append(" order by year(t.processDate), month(t.processDate) ");
        List<KeyDevelopmentsStatsPerMonthVO> list = this.list(hql.toString(), namedParameters);
        return list;
    }

    @Override
    public Calendar getOldestTransfer(Currency currency, Account account, Period period, boolean excludeChargebacks) {
        StringBuilder hql = new StringBuilder();
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        hql.append(" select min(t.processDate) from Transfer t  ");
        hql.append(" where 1=1 ");
        if (currency != null) {
            namedParameters.put("currency", currency);
            hql.append(" and t.to.type.currency = :currency ");
        }
        if (account != null) {
            namedParameters.put("account", account);
            hql.append(" and (t.from = :account or t.to = :account) ");
        }
        if (excludeChargebacks) {
            hql.append(" and t.chargedBackBy is null and t.chargebackOf is null ");
        }
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "t.processDate", period);
        hql.append(" order by t.processDate, t.id");
        return (Calendar)this.uniqueResult(hql.toString(), namedParameters);
    }

    @Override
    public List<Pair<Member, BigDecimal>> getPaymentsPerMember(StatisticalDTO dto) throws DaoException {
        return this.getGrossProductPerMember(dto);
    }

    @Override
    public BigDecimal getSumOfTransactions(StatisticalDTO dto) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder("select new " + Pair.class.getName());
        hql.append("(m, sum(t.amount)) from Transfer t, Member m where 1=1 ");
        hql.append(" and t.chargedBackBy is null and t.chargebackOf is null ");
        hql.append(" and exists (select ma.id from MemberAccount ma where t.to = ma and m = ma.member) ");
        this.appendGroupAndPaymentFilterAndPeriod(hql, namedParameters, dto);
        if (dto.getTransferType() != null) {
            hql.append(" and t.type = :transferType ");
            namedParameters.put("transferType", dto.getTransferType());
        }
        hql.append(" group by m ");
        List sums = this.list(hql.toString(), namedParameters);
        BigDecimal sumOfTransactions = BigDecimal.ZERO;
        for (Pair item : sums) {
            sumOfTransactions = sumOfTransactions.add((BigDecimal)item.getSecond());
        }
        return sumOfTransactions;
    }

    @Override
    public BigDecimal getSumOfTransactionsRest(TransferQuery query) {
        BigDecimal sumOfTransactions;
        Collection<PaymentFilter> paymentFilters;
        StringBuilder hql = new StringBuilder("select sum(t.amount) from Transfer t where 1=1 ");
        hql.append(" and t.chargedBackBy is null and t.chargebackOf is null ");
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "t.processDate", query.getPeriod());
        if (query.getFromAccountType() != null) {
            hql.append(" and t.from.type = :fromAccountType");
            namedParameters.put("fromAccountType", query.getFromAccountType());
        }
        if (query.getToAccountType() != null) {
            hql.append(" and t.to.type = :toAccountType");
            namedParameters.put("toAccountType", query.getToAccountType());
        }
        if ((paymentFilters = query.getPaymentFilters()) != null && !CollectionUtils.isEmpty(paymentFilters)) {
            HashSet<TransferType> transferTypesSet = new HashSet<TransferType>();
            for (PaymentFilter paymentFilter : paymentFilters) {
                transferTypesSet.addAll(paymentFilter.getTransferTypes());
            }
            hql.append(" and t.type not in (:transferTypes) ");
            namedParameters.put("transferTypes", transferTypesSet);
        }
        if ((sumOfTransactions = (BigDecimal)this.uniqueResult(hql.toString(), namedParameters)) == null) {
            return BigDecimal.ZERO;
        }
        return sumOfTransactions;
    }

    @Override
    public List<Number> getTransactionAmounts(StatisticalDTO dto) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder();
        hql.append("select new " + Pair.class.getName() + "(t.id, t.amount)");
        hql.append(" from Transfer t, Member m where 1=1 ");
        hql.append(" and t.chargedBackBy is null and t.chargebackOf is null ");
        hql.append(" and (exists (select ma.id from MemberAccount ma where t.to = ma and m = ma.member) ");
        hql.append(" or exists (select ma.id from MemberAccount ma where t.from = ma and m = ma.member)) ");
        this.appendGroupAndPaymentFilterAndPeriod(hql, namedParameters, dto);
        List pairList = this.list(hql.toString(), namedParameters);
        HashSet pairSet = new HashSet(pairList);
        return ListOperations.getSecondNumberFromPairCollection(pairSet);
    }

    @Override
    public BigDecimal getTransactionedAmountAt(Calendar date, Account account, TransferType transferType) {
        return this.getTransactionedAmountAt(date, null, account, transferType);
    }

    @Override
    public BigDecimal getTransactionedAmountAt(Calendar date, Operator operator, Account account, TransferType transferType) {
        if (date == null) {
            date = Calendar.getInstance();
        }
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder("select sum(t.amount) from Transfer t where 1=1 ");
        HibernateHelper.addInParameterToQuery(hql, namedParameters, "t.status", Payment.Status.PROCESSED, Payment.Status.PENDING, Payment.Status.SCHEDULED);
        HibernateHelper.addParameterToQuery(hql, namedParameters, "t.from", account);
        HibernateHelper.addParameterToQuery(hql, namedParameters, "t.type", transferType);
        HibernateHelper.addParameterToQuery(hql, namedParameters, "t.by", operator);
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "ifnull(t.processDate, t.date)", Period.day(date));
        BigDecimal sum = (BigDecimal)this.uniqueResult(hql.toString(), namedParameters);
        return BigDecimalHelper.nvl(sum);
    }

    @Override
    public List<Transfer> getTransfers(Currency currency, Account account, Period period, Transfer sinceTransfer, boolean includeChargebacks, Integer maxResults) {
        StringBuilder hql = new StringBuilder();
        if (sinceTransfer != null && sinceTransfer.getProcessDate() == null) {
            throw new IllegalArgumentException("transfer must be processed");
        }
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        hql.append(" from Transfer t  ");
        hql.append(" where 1=1 ");
        hql.append(" and t.processDate is not null ");
        if (currency != null) {
            namedParameters.put("currency", currency);
            hql.append(" and t.to.type.currency = :currency ");
        }
        if (account != null) {
            namedParameters.put("account", account);
            hql.append(" and (t.from = :account or t.to = :account) ");
        }
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "t.processDate", period);
        if (sinceTransfer != null) {
            namedParameters.put("id", sinceTransfer.getId());
            namedParameters.put("startDate", sinceTransfer.getProcessDate());
            hql.append(" and ( (t.processDate > :startDate) or ( (t.processDate = :startDate) and (t.id > :id) ) ) ");
        }
        if (!includeChargebacks) {
            hql.append(" and t.chargedBackBy is null and t.chargebackOf is null ");
        }
        hql.append(" order by t.processDate, t.id");
        List<Transfer> transfers = maxResults != null ? this.list(QueryParameters.ResultType.LIST, hql.toString(), namedParameters, PageParameters.max(maxResults), new Relationship[0]) : this.list(hql.toString(), namedParameters);
        return transfers;
    }

    @Override
    public boolean hasTransfers(Account account) {
        PageParameters pageParameters;
        String hql = "select t.id from Transfer t where t.from = :account or t.to = :account";
        Map<String, Account> params = Collections.singletonMap("account", account);
        List list = this.list(QueryParameters.ResultType.LIST, hql, params, pageParameters = PageParameters.max(1), new Relationship[0]);
        return !list.isEmpty();
    }

    @Override
    public Transfer loadTransferByTraceNumber(String traceNumber, Long clientId, Relationship ... fetch) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        List<Relationship> toFetch = ArrayUtils.isEmpty((Object[])fetch) ? null : Arrays.asList(fetch);
        StringBuilder hql = HibernateHelper.getInitialQuery(this.getEntityType(), "t", toFetch);
        HibernateHelper.addParameterToQuery(hql, namedParameters, "traceNumber", traceNumber);
        HibernateHelper.addParameterToQuery(hql, namedParameters, "clientId", clientId);
        return (Transfer)this.uniqueResult(hql.toString(), namedParameters);
    }

    @Override
    public List<SimpleTransferVO> paymentVOs(Account account, Period period) throws DaoException {
        StringBuilder hql = new StringBuilder();
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        namedParameters.put("account", account);
        hql.append("select new ").append(SimpleTransferVO.class.getName()).append("(t.date, case t.from when :account then -t.amount else t.amount end)");
        hql.append(" from ").append(this.getEntityType().getName()).append(" t");
        hql.append(" where (t.from = :account or t.to = :account) ");
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "t.date", period);
        hql.append(" order by t.date");
        return this.list(hql.toString(), namedParameters);
    }

    @Override
    public List<Transfer> search(TransferQuery query) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder();
        hql.append(" select t");
        hql.append(" from Loan l right join l.transfer t ");
        this.hibernateCustomFieldHandler.appendJoins(hql, "t.customValues", query.getCustomValues());
        HibernateHelper.appendJoinFetch(hql, Transfer.class, "t", query.getFetch());
        hql.append(" where 1=1");
        if (!this.buildSearchQuery(query, hql, namedParameters)) {
            return Collections.emptyList();
        }
        return this.list(query, hql.toString(), namedParameters);
    }

    @Override
    public List<Transfer> searchTransfersAwaitingAuthorization(TransfersAwaitingAuthorizationQuery query) {
        PaymentFilter paymentFilter;
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder();
        hql.append(" select t from Transfer t join t.nextAuthorizationLevel l ");
        HibernateHelper.appendJoinFetch(hql, this.getEntityType(), "t", query.getFetch());
        hql.append(" where 1=1");
        Element authorizer = query.getAuthorizer();
        if (authorizer == null) {
            return Collections.emptyList();
        }
        authorizer = this.getFetchDao().fetch(authorizer, Element.Relationships.GROUP);
        for (AuthorizationLevel.Authorizer auth : AuthorizationLevel.Authorizer.values()) {
            namedParameters.put(auth.name(), auth);
        }
        namedParameters.put("authorizer", authorizer);
        hql.append(" and t.parent is null");
        hql.append(" and t.processDate is null and t.status = :status ");
        namedParameters.put("status", Payment.Status.PENDING);
        if (authorizer instanceof Administrator) {
            Administrator administrator = (Administrator)authorizer;
            hql.append(" and l.authorizer in (:ADMIN, :BROKER)");
            hql.append(" and :adminGroup in elements(l.adminGroups)");
            namedParameters.put("adminGroup", administrator.getAdminGroup());
        } else if (authorizer instanceof Operator) {
            hql.append(" and ((l.authorizer = :RECEIVER and exists (");
            hql.append(" select ma.id from MemberAccount ma, Operator o where ma = t.to and o.member = ma.member and o = :authorizer");
            hql.append(" )) or (l.authorizer = :PAYER and exists (");
            hql.append(" select ma.id from MemberAccount ma, Operator o where ma = t.from and o.member = ma.member and o = :authorizer");
            hql.append(" ))) ");
        } else {
            hql.append(" and ((l.authorizer = :BROKER and exists(");
            hql.append(" select ma.id from MemberAccount ma where ma = t.from and ma.member.broker = :authorizer");
            hql.append(" )) or (l.authorizer = :RECEIVER and exists (");
            hql.append(" select ma.id from MemberAccount ma where ma = t.to and ma.member = :authorizer");
            hql.append(" )) or (l.authorizer = :PAYER and exists (");
            hql.append(" select ma.id from MemberAccount ma where ma = t.from and ma.member = :authorizer");
            hql.append(")))");
        }
        hql.append(" and not exists (select a.id from TransferAuthorization a where a.transfer = t and a.by = :authorizer)");
        Member member = query.getMember();
        if (member != null) {
            hql.append(" and exists (select ma.id from MemberAccount ma where ma.member = :member and (ma = t.from or ma = t.to))");
            namedParameters.put("member", member);
        }
        if ((paymentFilter = query.getPaymentFilter()) != null) {
            paymentFilter = this.getFetchDao().fetch(paymentFilter, PaymentFilter.Relationships.TRANSFER_TYPES);
            HibernateHelper.addInParameterToQuery(hql, namedParameters, "t.type", paymentFilter.getTransferTypes());
        }
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "t.date", query.getPeriod());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "t.type", query.getTransferType());
        HibernateHelper.addLikeParameterToQuery(hql, namedParameters, "t.transactionNumber", query.getTransactionNumber());
        HibernateHelper.appendOrder(hql, "t.date desc");
        return this.list(query, hql.toString(), namedParameters);
    }

    public void setAccountDao(AccountDAO accountDao) {
        this.accountDao = accountDao;
    }

    public void setHibernateCustomFieldHandler(HibernateCustomFieldHandler hibernateCustomFieldHandler) {
        this.hibernateCustomFieldHandler = hibernateCustomFieldHandler;
    }

    @Override
    public Transfer updateAuthorizationData(Long id, Payment.Status status, AuthorizationLevel nextAuthorizationLevel, Calendar processDate, Rated rates) {
        Transfer transfer = (Transfer)this.load(id, new Relationship[0]);
        transfer.setStatus(status);
        transfer.setNextAuthorizationLevel(nextAuthorizationLevel);
        transfer.setProcessDate(processDate);
        if (rates != null) {
            if ((rates.getEmissionDate() != null || rates.getExpirationDate() != null) && transfer.getProcessDate() == null) {
                throw new IllegalArgumentException("rates can only be set if processDate on the transfer is NOT null. ");
            }
            transfer.setEmissionDate(rates.getEmissionDate());
            transfer.setExpirationDate(rates.getExpirationDate());
            transfer.setiRate(rates.getiRate());
        }
        return this.update(transfer);
    }

    @Override
    public Transfer updateChargeBack(Transfer transfer, Transfer chargeback) {
        transfer.setChargedBackBy(chargeback);
        return this.update(transfer);
    }

    @Override
    public Transfer updateExternalTransfer(Long id, ExternalTransfer externalTransfer) {
        Transfer transfer = (Transfer)this.load(id, new Relationship[0]);
        transfer.setExternalTransfer(externalTransfer);
        return this.update(transfer);
    }

    @Override
    public Transfer updateStatus(Long id, Payment.Status status) {
        Transfer transfer = (Transfer)this.load(id, new Relationship[0]);
        transfer.setStatus(status);
        if (status != Payment.Status.PROCESSED) {
            transfer.setProcessDate(null);
        }
        return this.update(transfer);
    }

    @Override
    public Transfer updateTransactionNumber(Long id, String transactionNumber) {
        Transfer transfer = (Transfer)this.load(id, new Relationship[0]);
        transfer.setTransactionNumber(transactionNumber);
        return this.update(transfer);
    }

    private void appendGroupAndPaymentFilterAndPeriod(StringBuilder hql, Map<String, Object> namedParameters, StatisticalDTO dto) {
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "t.processDate", dto.getPeriod());
        if (dto.getPaymentFilter() != null) {
            hql.append(" and exists (select 1 from " + PaymentFilter.class.getName() + " pf where pf = :filter and t.type in elements(pf.transferTypes)) ");
            namedParameters.put("filter", dto.getPaymentFilter());
        }
        if (!CollectionUtils.isEmpty(dto.getGroups())) {
            hql.append(" and exists ");
            hql.append("    ( select ghl.id ");
            hql.append("      from GroupHistoryLog ghl ");
            hql.append("      where ghl.element = m ");
            hql.append("      and ghl.group in (:groups) ");
            hql.append("      and ghl.period.begin < :end ");
            hql.append("      and (ghl.period.end is null or ghl.period.end >= :begin) ");
            hql.append("      and t.processDate between ghl.period.begin and ifnull(ghl.period.end, t.processDate) ");
            hql.append("    ) ");
            namedParameters.put("groups", dto.getGroups());
            namedParameters.put("begin", dto.getPeriod().getBegin());
            namedParameters.put("end", dto.getPeriod().getEnd());
        }
    }

    private boolean buildSearchQuery(TransferQuery query, StringBuilder hql, Map<String, Object> namedParameters) {
        Collection<PaymentFilter> paymentFilters;
        AccountQuery accountQuery;
        HibernateHelper.addParameterToQuery(hql, namedParameters, "t.type.requiresAuthorization", query.getRequiresAuthorization());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "t.status", query.getStatus());
        HibernateHelper.addLikeParameterToQuery(hql, namedParameters, "t.description", query.getDescription());
        HibernateHelper.addLikeParameterToQuery(hql, namedParameters, "t.transactionNumber", query.getTransactionNumber());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "t.loanPayment", query.getLoanPayment());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "t.parent", query.getParent());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "t.type", query.getTransferType());
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "ifnull(t.processDate, t.date)", query.getPeriod());
        if (query.isRootOnly()) {
            hql.append(" and t.parent is null");
        }
        if (query.getLoanTransfer() != null) {
            if (query.getLoanTransfer().booleanValue()) {
                hql.append(" and l is not null");
            } else {
                hql.append(" and l is null");
            }
        }
        if (query.getConciliated() != null) {
            hql.append(" and t.externalTransfer is " + (query.getConciliated() != false ? "not" : "") + " null");
        }
        if (query.getOwner() != null) {
            Collection<Account> accounts;
            if (query.getType() == null) {
                AccountQuery aq = new AccountQuery();
                aq.setOwner(query.getOwner());
                accounts = this.accountDao.search(aq);
            } else {
                Account account = this.accountDao.load(query.getOwner(), query.getType(), new Relationship[0]);
                accounts = Collections.singleton(account);
            }
            namedParameters.put("accounts", accounts);
            if (query.getMember() != null) {
                AccountQuery otherAccountsQuery = new AccountQuery();
                otherAccountsQuery.setOwner(query.getMember());
                List<? extends Account> otherAccounts = this.accountDao.search(otherAccountsQuery);
                if (otherAccounts.isEmpty()) {
                    return false;
                }
                hql.append(" and ((t.from in (:accounts) and t.to in (:relatedAccounts)) or (t.to in (:accounts) and t.from in (:relatedAccounts)))");
                namedParameters.put("relatedAccounts", otherAccounts);
            } else {
                hql.append(" and (t.from in (:accounts) or t.to in (:accounts))");
            }
            Collection<Object> groups = new HashSet();
            if (CollectionUtils.isNotEmpty(query.getGroupFilters())) {
                for (GroupFilter groupFilter : query.getGroupFilters()) {
                    if (groupFilter == null || !groupFilter.isPersistent()) continue;
                    groupFilter = this.getFetchDao().fetch(groupFilter, GroupFilter.Relationships.GROUPS);
                    groups.addAll(groupFilter.getGroups());
                }
            }
            if (CollectionUtils.isNotEmpty(query.getGroups())) {
                if (!groups.isEmpty()) {
                    groups.retainAll(query.getGroups());
                } else {
                    groups = query.getGroups();
                }
            }
            if (!groups.isEmpty()) {
                hql.append(" and ((t.to in (:accounts) and exists (select ma.id from MemberAccount ma where ma = t.from and ma.member.group in (:groups)))");
                hql.append("   or (t.from in (:accounts) and exists (select ma.id from MemberAccount ma where ma = t.to and ma.member.group in (:groups))))");
                namedParameters.put("groups", groups);
            }
        }
        if (query.getFromAccountOwner() != null) {
            accountQuery = new AccountQuery();
            accountQuery.setOwner(query.getFromAccountOwner());
            List<? extends Account> fromAccounts = this.accountDao.search(accountQuery);
            hql.append(" and t.from in (:fromAccounts) ");
            namedParameters.put("fromAccounts", fromAccounts);
        }
        if (query.getToAccountOwner() != null) {
            accountQuery = new AccountQuery();
            accountQuery.setOwner(query.getToAccountOwner());
            List<? extends Account> toAccounts = this.accountDao.search(accountQuery);
            hql.append(" and t.to in (:toAccounts) ");
            namedParameters.put("toAccounts", toAccounts);
        }
        if (CollectionUtils.isNotEmpty(paymentFilters = query.getPaymentFilters())) {
            String ttHql = "from TransferType tt where exists ( select 1 from PaymentFilter pf where pf in (:pfs) and tt in elements(pf.transferTypes))";
            List transferTypes = this.list("from TransferType tt where exists ( select 1 from PaymentFilter pf where pf in (:pfs) and tt in elements(pf.transferTypes))", Collections.singletonMap("pfs", paymentFilters));
            HibernateHelper.addInParameterToQuery(hql, namedParameters, "t.type", transferTypes);
        }
        if (query.getExcludeTransferType() != null) {
            hql.append(" and t.type != :excludeTransferType ");
            namedParameters.put("excludeTransferType", query.getExcludeTransferType());
        }
        if (query.getBy() != null) {
            hql.append(" and (t.by = :by or t.receiver = :by)");
            namedParameters.put("by", query.getBy());
        }
        this.hibernateCustomFieldHandler.appendConditions(hql, namedParameters, query.getCustomValues());
        if (!query.isUnordered()) {
            ArrayList<String> orders = new ArrayList<String>();
            String order = "ifnull(t.processDate, t.date)";
            if (query.isReverseOrder()) {
                order = order + " desc";
            }
            orders.add(order);
            order = "t.id";
            if (query.isReverseOrder()) {
                order = order + " desc";
            }
            orders.add(order);
            HibernateHelper.appendOrder(hql, orders);
        }
        return true;
    }
}

