/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.accounts.transactions;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.accounts.transactions.TransferTypeDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.MemberGroupAccountSettings;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.transactions.AuthorizationLevel;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import org.apache.commons.collections.CollectionUtils;

public class TransferTypeDAOImpl
extends BaseDAOImpl<TransferType>
implements TransferTypeDAO {
    public TransferTypeDAOImpl() {
        super(TransferType.class);
    }

    @Override
    public int delete(boolean flush, Long ... ids) {
        int rows = 0;
        for (Long id : ids) {
            try {
                TransferType transferType = (TransferType)this.load(id, TransferType.Relationships.GROUPS, TransferType.Relationships.GROUPS_AS_MEMBER);
                for (Group group : transferType.getGroups()) {
                    group.getTransferTypes().remove(transferType);
                }
                for (Group group : transferType.getGroupsAsMember()) {
                    group.getTransferTypes().remove(transferType);
                }
                this.bulkUpdate("update " + MemberGroupAccountSettings.class.getName() + " set initialCreditTransferType=null where (initialCredit is null or initialCredit = 0) and initialCreditTransferType=:tt", Collections.singletonMap("tt", transferType));
                this.getHibernateTemplate().delete((Object)transferType);
                this.getHibernateTemplate().flush();
                ++rows;
            }
            catch (EntityNotFoundException e) {
                // empty catch block
            }
        }
        return rows;
    }

    @Override
    public List<TransferType> search(TransferTypeQuery query) {
        AccountOwner fromOrToOwner;
        AccountOwner toOwner;
        AccountOwner fromOwner;
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        namedParameters.put("system", AccountType.Nature.SYSTEM.getValue());
        Set<Relationship> fetch = query.getFetch();
        StringBuilder hql = HibernateHelper.getInitialQuery(this.getEntityType(), "tt", fetch);
        HibernateHelper.addLikeParameterToQuery(hql, namedParameters, "tt.description", query.getDescription());
        HibernateHelper.addLikeParameterToQuery(hql, namedParameters, "tt.name", query.getName());
        TransactionContext context = query.getContext();
        if (context != null && context != TransactionContext.ANY) {
            switch (context) {
                case PAYMENT: {
                    hql.append(" and tt.loan.type is null and tt.context.payment=true ");
                    break;
                }
                case SELF_PAYMENT: {
                    hql.append(" and tt.loan.type is null and tt.context.selfPayment=true ");
                    break;
                }
                case LOAN: {
                    hql.append(" and tt.loan.type is not null and tt.context.payment=true ");
                    break;
                }
                case AUTOMATIC: {
                    hql.append(" and tt.loan.type is null ");
                    break;
                }
                case AUTOMATIC_LOAN: {
                    hql.append(" and tt.loan.type is not null ");
                }
            }
        }
        if (query.getChannel() != null) {
            hql.append(" and exists (select c.id from Channel c where c in elements(tt.channels) and c.internalName = :channel) ");
            namedParameters.put("channel", query.getChannel());
        }
        if (query.getCurrency() != null) {
            hql.append(" and tt.from.currency = :currency");
            namedParameters.put("currency", query.getCurrency());
        }
        if (query.getBy() != null) {
            Element by = this.getFetchDao().fetch(query.getBy(), Element.Relationships.GROUP);
            Group group = by.getGroup();
            hql.append(" and exists (select amtt.id from " + group.getClass().getName() + " g join g.transferTypesAsMember amtt where g = :byGroup and amtt = tt)");
            namedParameters.put("byGroup", group);
        }
        if ((fromOwner = query.getFromOwner()) != null) {
            if (fromOwner instanceof SystemAccountOwner) {
                query.setFromNature(AccountType.Nature.SYSTEM);
            } else {
                Member member = this.getFetchDao().fetch((Member)fromOwner, Element.Relationships.GROUP);
                query.setFromGroups(Collections.singleton(member.getMemberGroup()));
            }
        }
        if ((toOwner = query.getToOwner()) != null) {
            if (toOwner instanceof SystemAccountOwner) {
                query.setToNature(AccountType.Nature.SYSTEM);
            } else {
                Member member = this.getFetchDao().fetch((Member)toOwner, Element.Relationships.GROUP);
                query.setToGroups(Collections.singleton(member.getMemberGroup()));
                hql.append(" and (tt.fixedDestinationMember = :toMember or tt.fixedDestinationMember is null) ");
                namedParameters.put("toMember", member);
            }
        }
        if ((fromOrToOwner = query.getFromOrToOwner()) != null) {
            if (fromOrToOwner instanceof SystemAccountOwner) {
                query.setFromOrToNature(AccountType.Nature.SYSTEM);
            } else {
                Member member = this.getFetchDao().fetch((Member)fromOrToOwner, Element.Relationships.GROUP);
                query.setFromOrToGroups(Collections.singleton(member.getMemberGroup()));
            }
        }
        if (CollectionUtils.isNotEmpty(query.getFromGroups())) {
            hql.append(" and exists (select mgas.id from MemberGroupAccountSettings mgas where mgas.group in (:fromGroups) and mgas.accountType = tt.from) ");
            namedParameters.put("fromGroups", query.getFromGroups());
        }
        if (CollectionUtils.isNotEmpty(query.getToGroups())) {
            hql.append(" and exists (select mgas.id from MemberGroupAccountSettings mgas where mgas.group in (:toGroups) and mgas.accountType = tt.to) ");
            namedParameters.put("toGroups", query.getToGroups());
        }
        if (CollectionUtils.isNotEmpty(query.getFromOrToGroups())) {
            hql.append(" and exists (select mgas.id from MemberGroupAccountSettings mgas where mgas.group in (:fromOrToGroups) and (mgas.accountType = tt.from or mgas.accountType = tt.to)) ");
            namedParameters.put("fromOrToGroups", query.getFromOrToGroups());
        }
        if (query.getFromNature() != null) {
            hql.append(" and tt.from.class = :fromNature");
            namedParameters.put("fromNature", query.getFromNature().getValue());
        }
        if (query.getToNature() != null) {
            hql.append(" and tt.to.class = :toNature");
            namedParameters.put("toNature", query.getToNature().getValue());
        }
        if (query.getFromOrToNature() != null) {
            hql.append(" and (tt.from.class = :fromOrToNature or tt.to.class = :fromOrToNature)");
            namedParameters.put("fromOrToNature", query.getFromOrToNature().getValue());
        }
        if (query.getFromLimitType() != null) {
            if (query.getFromLimitType().equals((Object)AccountType.LimitType.UNLIMITED)) {
                hql.append(" and tt.from.account.creditLimit is null");
            } else {
                hql.append(" and tt.from.account.creditLimit is not null");
            }
        }
        if (query.getToLimitType() != null) {
            if (query.getToLimitType().equals((Object)AccountType.LimitType.UNLIMITED)) {
                hql.append(" and tt.to.account.creditLimit is null");
            } else {
                hql.append(" and tt.to.account.creditLimit is not null");
            }
        }
        HibernateHelper.addInParameterToQuery(hql, namedParameters, "tt.from", query.getFromAccountTypes());
        HibernateHelper.addInParameterToQuery(hql, namedParameters, "tt.to", query.getToAccountTypes());
        Collection<? extends AccountType> accountTypes = query.getFromOrToAccountTypes();
        if (accountTypes != null && !accountTypes.isEmpty()) {
            hql.append(" and (tt.to in (:fromOrToAT) or tt.from in (:fromOrToAT))");
            namedParameters.put("fromOrToAT", accountTypes);
        }
        if (query.getGroup() != null) {
            hql.append(" and :group in elements(tt.groups)");
            namedParameters.put("group", query.getGroup());
        }
        if (query.isPriority()) {
            hql.append(" and tt.priority = true ");
        }
        if (query.isConciliable()) {
            hql.append(" and tt.conciliable = true ");
        }
        if (query.isAuthorizable()) {
            hql.append(" and tt.requiresAuthorization = true");
            Collection<AuthorizationLevel.Authorizer> authorizers = query.getAuthorizers();
            if (CollectionUtils.isNotEmpty(authorizers)) {
                AdminGroup authorizerGroup = query.getAuthorizerGroup();
                namedParameters.put("authorizerGroup", authorizerGroup);
                hql.append(" and (1<>1");
                for (AuthorizationLevel.Authorizer authorizer : authorizers) {
                    String name = "authorizer_" + authorizer.ordinal();
                    hql.append(" or exists (select l.id from AuthorizationLevel l where l.transferType = tt and l.authorizer = :" + name);
                    if (authorizerGroup != null) {
                        hql.append(" and :authorizerGroup in elements(l.adminGroups)");
                    }
                    hql.append(")");
                    namedParameters.put(name, authorizer);
                }
                hql.append(")");
            }
        }
        if (query.isSchedulable()) {
            hql.append(" and tt.allowsScheduledPayments = true");
        }
        if (CollectionUtils.isNotEmpty(query.getPossibleTransferTypes())) {
            hql.append(" and tt in (:_possible)");
            namedParameters.put("_possible", query.getPossibleTransferTypes());
        }
        HibernateHelper.appendOrder(hql, "tt.name");
        return this.list(query, hql.toString(), namedParameters);
    }
}

