/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.ads;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.ads.AdCategoryDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.ads.AdCategory;
import nl.strohalm.cyclos.entities.ads.AdCategoryQuery;
import nl.strohalm.cyclos.entities.ads.AdQuery;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import org.apache.commons.beanutils.BeanComparator;

public class AdCategoryDAOImpl
extends BaseDAOImpl<AdCategory>
implements AdCategoryDAO {
    public AdCategoryDAOImpl() {
        super(AdCategory.class);
    }

    @Override
    public List<Long> getActiveCategoriesId() {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder();
        hql.append("select cat.id from AdCategory cat");
        hql.append(" where 1=1");
        HibernateHelper.addParameterToQuery(hql, namedParameters, "cat.active", true);
        return this.list(new AdQuery(), hql.toString(), namedParameters);
    }

    @Override
    public Iterator<AdCategory> iterateAll() {
        return this.getHibernateTemplate().iterate("from " + this.getEntityType().getName());
    }

    @Override
    public List<AdCategory> search(AdCategoryQuery query) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = this.getBasicQuery(query);
        if (query.getParent() != null) {
            HibernateHelper.addParameterToQuery(hql, namedParameters, "c.parent", query.getParent());
        } else {
            hql.append(" and c.parent is null ");
        }
        String[] order = query.isOrderAlphabetically() ? new String[]{"c.name"} : new String[]{"c.order", "c.name"};
        HibernateHelper.appendOrder(hql, order);
        return this.list(query, hql.toString(), namedParameters);
    }

    @Override
    public List<AdCategory> searchLeafAdCategories(AdCategoryQuery query) {
        HashMap namedParameters = new HashMap();
        StringBuilder hql = this.getBasicQuery(query);
        hql.append(" and not exists (select c1.id from AdCategory c1 where c1.parent = c) ");
        List<AdCategory> categories = this.list(query, hql.toString(), namedParameters);
        Collections.sort(categories, new BeanComparator("globalOrder"));
        return categories;
    }

    private StringBuilder getBasicQuery(AdCategoryQuery query) {
        StringBuilder hql = new StringBuilder();
        Set<Relationship> fetch = query.getFetch();
        hql.append(" select c");
        hql.append(" from AdCategory c left join c.parent p left join p.parent p1");
        HibernateHelper.appendJoinFetch(hql, this.getEntityType(), "c", fetch);
        hql.append(" where 1=1 ");
        if (!query.isReturnDisabled()) {
            hql.append(" and c.active = true ");
            hql.append(" and (p is null or p.active = true) ");
            hql.append(" and (p1 is null or p1.active = true) ");
        }
        return hql;
    }
}

