/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.ads;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import nl.strohalm.cyclos.dao.IndexedDAOImpl;
import nl.strohalm.cyclos.dao.ads.AdDAO;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.ads.AdCategory;
import nl.strohalm.cyclos.entities.ads.AdCategoryWithCounterQuery;
import nl.strohalm.cyclos.entities.ads.AdCategoryWithCounterVO;
import nl.strohalm.cyclos.entities.ads.AdQuery;
import nl.strohalm.cyclos.entities.ads.FullTextAdQuery;
import nl.strohalm.cyclos.entities.customization.fields.AdCustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomFieldValue;
import nl.strohalm.cyclos.entities.customization.images.AdImage;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.exceptions.QueryParseException;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.hibernate.HibernateCustomFieldHandler;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import nl.strohalm.cyclos.utils.lucene.Filters;
import nl.strohalm.cyclos.utils.lucene.LuceneUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermRangeFilter;
import org.apache.lucene.search.TotalHitCountCollector;

public class AdDAOImpl
extends IndexedDAOImpl<Ad>
implements AdDAO {
    private static final String[] FIELDS_FULL_TEXT = new String[]{"title", "description", "customValues", "owner.name", "owner.email", "owner.username", "owner.customValues"};
    private HibernateCustomFieldHandler hibernateCustomFieldHandler;

    public AdDAOImpl() {
        super(Ad.class);
    }

    @Override
    public int delete(boolean flush, Long ... ids) {
        if (ids != null && ids.length > 0) {
            HashMap<String, List<Long>> namedParameters = new HashMap<String, List<Long>>();
            namedParameters.put("ids", Arrays.asList(ids));
            this.bulkUpdate("delete from " + AdCustomFieldValue.class.getName() + " v where v.ad.id in (:ids)", namedParameters);
            this.bulkUpdate("delete from " + AdImage.class.getName() + " ai where ai.ad.id in (:ids)", namedParameters);
            Integer results = CoercionHelper.coerce(Integer.TYPE, this.bulkUpdate("update Ad ad set ad.deleteDate = current_date(), ad.description = null where ad.id in (:ids)", namedParameters));
            if (flush) {
                this.flush();
            }
            return results;
        }
        return 0;
    }

    @Override
    public List<Ad> fullTextSearch(FullTextAdQuery adQuery) throws DaoException {
        FullTextSearchElements elements = this.prepare(adQuery);
        return this.list(Ad.class, adQuery, elements.getQuery(), elements.getFilters(), elements.getSort());
    }

    @Override
    public List<AdCategoryWithCounterVO> getCategoriesWithCounters(List<AdCategory> categories, AdCategoryWithCounterQuery acQuery) {
        IndexReader reader = null;
        IndexSearcher searcher = null;
        ArrayList<AdCategoryWithCounterVO> result = new ArrayList<AdCategoryWithCounterVO>(categories.size());
        try {
            Long[] groupIds;
            reader = this.indexHandler.openReader(Ad.class);
            searcher = new IndexSearcher(reader);
            FullTextAdQuery adQuery = new FullTextAdQuery();
            adQuery.setStatus(Ad.Status.ACTIVE);
            adQuery.setTradeType(acQuery.getTradeType());
            if (acQuery.isExternalPublication()) {
                adQuery.setExternalPublication(true);
            }
            if ((groupIds = acQuery.getGroupIds()) != null) {
                adQuery.setGroups(Arrays.asList(EntityHelper.references(MemberGroup.class, Arrays.asList(groupIds))));
            }
            FullTextSearchElements elements = this.prepare(adQuery);
            Query query = elements.getQuery();
            Filters baseFilters = elements.getFilters();
            for (AdCategory adCategory : categories) {
                AdCategoryWithCounterVO counter = this.createCounter(searcher, query, baseFilters, adCategory, null, 1);
                result.add(counter);
            }
            ArrayList<AdCategoryWithCounterVO> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            throw new DaoException(e);
        }
        finally {
            try {
                searcher.close();
            }
            catch (Exception e) {}
            try {
                reader.close();
            }
            catch (Exception e) {}
        }
    }

    @Override
    public Integer getNumberOfAds(Calendar date, Collection<? extends Group> groups, Ad.Status status) {
        return this.count(date, groups, status, "count(ad.id)");
    }

    @Override
    public Integer getNumberOfCreatedAds(Period period, Collection<? extends Group> groups) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder("select count(ad.id) from Ad ad where 1=1");
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "ad.creationDate", period);
        if (!CollectionUtils.isEmpty(groups)) {
            hql.append(" and ad.owner.group in (:groups) ");
            namedParameters.put("groups", groups);
        }
        return (Integer)this.uniqueResult(hql.toString(), namedParameters);
    }

    @Override
    public Integer getNumberOfMembersWithAds(Calendar date, Collection<? extends Group> groups) throws DaoException {
        return this.count(date, groups, Ad.Status.ACTIVE, "count(distinct ad.owner.id)");
    }

    @Override
    public List<Ad> search(AdQuery query) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder();
        hql.append(" select ad");
        hql.append(" from Ad ad inner join ad.owner m left join ad.category c1 left join c1.parent c2 left join c2.parent c3 ");
        this.hibernateCustomFieldHandler.appendJoins(hql, "ad.customValues", query.getAdValues());
        this.hibernateCustomFieldHandler.appendJoins(hql, "m.customValues", query.getMemberValues());
        HibernateHelper.appendJoinFetch(hql, this.getEntityType(), "ad", query.getFetch());
        hql.append(" where 1=1");
        if (query.getCategory() != null) {
            hql.append(" and (c1 = :adCategory or c2 = :adCategory or c3 = :adCategory)");
            namedParameters.put("adCategory", query.getCategory());
        }
        if (!query.isIncludeDeleted()) {
            hql.append(" and ad.deleteDate is null ");
        }
        HibernateHelper.addParameterToQuery(hql, namedParameters, "ad.category.active", true);
        HibernateHelper.addParameterToQuery(hql, namedParameters, "ad.id", query.getId());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "ad.membersNotified", query.getMembersNotified());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "ad.externalPublication", query.getExternalPublication());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "m", query.getOwner());
        HibernateHelper.addInParameterToQuery(hql, namedParameters, "m.group", query.getGroups());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "ad.tradeType", query.getTradeType());
        HibernateHelper.addParameterToQueryOperator(hql, namedParameters, "ad.price", ">=", query.getInitialPrice());
        HibernateHelper.addParameterToQueryOperator(hql, namedParameters, "ad.price", "<=", query.getFinalPrice());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "ad.currency", query.getCurrency());
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "ad.publicationPeriod.begin", Period.day(query.getBeginDate()));
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "ad.publicationPeriod.end", Period.day(query.getEndDate()));
        Calendar now = Calendar.getInstance();
        if (query.getSince() != null && query.getSince().getNumber() > 0) {
            Calendar since = DateHelper.truncate(query.getSince().remove(now));
            HibernateHelper.addParameterToQueryOperator(hql, namedParameters, "ad.publicationPeriod.begin", ">=", since);
        }
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "ad.publicationPeriod.begin", query.getPeriod());
        if (query.isWithImagesOnly()) {
            hql.append(" and exists (select img.id from AdImage img where img.ad = ad) ");
        }
        Calendar historyDate = (Calendar)ObjectUtils.defaultIfNull((Object)query.getHistoryDate(), (Object)Calendar.getInstance());
        HibernateHelper.addParameterToQueryOperator(hql, namedParameters, "ad.creationDate", "<=", historyDate);
        hql.append(" and (ad.deleteDate is null or ad.deleteDate >= :historyDate)");
        namedParameters.put("historyDate", historyDate);
        if (query.getStatus() != null) {
            switch (query.getStatus()) {
                case PERMANENT: {
                    hql.append(" and ad.permanent = true ");
                    break;
                }
                case ACTIVE: {
                    hql.append(" and (ad.permanent = true or ((ad.publicationPeriod.end is null or ad.publicationPeriod.end >= :historyDate) and ad.publicationPeriod.begin <= :historyDate)) ");
                    break;
                }
                case SCHEDULED: {
                    hql.append(" and (ad.permanent is null or ad.permanent = false) and ad.publicationPeriod.begin > :historyDate ");
                    break;
                }
                case EXPIRED: {
                    hql.append(" and (ad.permanent is null or ad.permanent = false) and ad.publicationPeriod.end < :historyDate ");
                }
            }
        }
        if (StringUtils.isNotEmpty((String)query.getKeywords())) {
            hql.append(" and ((ad.title like :keywords) or (ad.description like :keywords))");
            namedParameters.put("keywords", "%" + query.getKeywords() + "%");
        }
        this.hibernateCustomFieldHandler.appendConditions(hql, namedParameters, query.getAdValues());
        this.hibernateCustomFieldHandler.appendConditions(hql, namedParameters, query.getMemberValues());
        if (query.isRandomOrder()) {
            HibernateHelper.appendOrder(hql, "rand()");
        } else {
            HibernateHelper.appendOrder(hql, "ad.publicationPeriod.begin desc, ad.id desc");
        }
        return this.list(query, hql.toString(), namedParameters);
    }

    public void setHibernateCustomFieldHandler(HibernateCustomFieldHandler hibernateCustomFieldHandler) {
        this.hibernateCustomFieldHandler = hibernateCustomFieldHandler;
    }

    private Integer count(Calendar date, Collection<? extends Group> groups, Ad.Status status, String projection) {
        if (date == null) {
            date = Calendar.getInstance();
        }
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder("select " + projection + " from Ad ad where 1=1");
        HibernateHelper.addParameterToQueryOperator(hql, namedParameters, "ad.creationDate", "<=", date);
        hql.append(" and (ad.deleteDate is null or ad.deleteDate > :date)");
        if (!CollectionUtils.isEmpty(groups)) {
            hql.append(" and ad.owner.group in (:groups) ");
            namedParameters.put("groups", groups);
        }
        switch (status) {
            case ACTIVE: {
                hql.append(" and ad.publicationPeriod.begin <= :date");
                hql.append(" and (ad.permanent = true or ad.publicationPeriod.end > :date)");
                break;
            }
            case PERMANENT: {
                hql.append(" and ad.publicationPeriod.begin <= :date");
                hql.append(" and ad.permanent = true");
                break;
            }
            case EXPIRED: {
                HibernateHelper.addParameterToQueryOperator(hql, namedParameters, "ad.publicationPeriod.begin", "<=", date);
                HibernateHelper.addParameterToQueryOperator(hql, namedParameters, "ad.publicationPeriod.end", "<=", date);
                break;
            }
            case SCHEDULED: {
                HibernateHelper.addParameterToQueryOperator(hql, namedParameters, "ad.publicationPeriod.begin", ">", date);
            }
        }
        namedParameters.put("date", date);
        return (Integer)this.uniqueResult(hql.toString(), namedParameters);
    }

    private AdCategoryWithCounterVO createCounter(IndexSearcher searcher, Query query, Filters baseFilters, AdCategory adCategory, AdCategoryWithCounterVO parent, int level) throws IOException {
        Filters filters = (Filters)baseFilters.clone();
        filters.addTerms("category", adCategory.getId());
        TotalHitCountCollector collector = new TotalHitCountCollector();
        searcher.search(query, (Filter)filters, (Collector)collector);
        int totalCount = collector.getTotalHits();
        AdCategoryWithCounterVO counter = new AdCategoryWithCounterVO(adCategory.getId(), adCategory.getName(), level, totalCount, parent);
        for (AdCategory childCategory : adCategory.getChildren()) {
            AdCategoryWithCounterVO childCounter = this.createCounter(searcher, query, baseFilters, childCategory, counter, level + 1);
            counter.addChild(childCounter);
        }
        return counter;
    }

    private MultiFieldQueryParser getQueryParser(Analyzer analyzer) {
        HashMap<String, Float> boosts = new HashMap<String, Float>();
        boosts.put("title", Float.valueOf(2.5f));
        boosts.put("description", Float.valueOf(2.0f));
        boosts.put("owner.name", Float.valueOf(1.5f));
        boosts.put("owner.username", Float.valueOf(1.3f));
        return new MultiFieldQueryParser(LuceneUtils.LUCENE_VERSION, FIELDS_FULL_TEXT, analyzer, boosts);
    }

    private FullTextSearchElements prepare(FullTextAdQuery adQuery) {
        Ad.Status status;
        MatchAllDocsQuery query;
        String keywords = adQuery.getKeywords();
        Calendar today = DateHelper.truncate(Calendar.getInstance());
        Sort sort = null;
        Analyzer analyzer = adQuery.getAnalyzer();
        if (keywords == null) {
            query = new MatchAllDocsQuery();
            sort = new Sort(new SortField("baseDate", 3, true));
        } else {
            try {
                query = this.getQueryParser(analyzer).parse(keywords);
            }
            catch (ParseException e) {
                throw new QueryParseException(e);
            }
        }
        Filters filters = new Filters();
        filters.addTerms("id", adQuery.getId());
        filters.addTerms("membersNotified", adQuery.getMembersNotified());
        filters.addTerms("category", adQuery.getCategoriesIds());
        filters.addTerms("currency", adQuery.getCurrency());
        filters.addTerms("externalPublication", adQuery.getExternalPublication());
        filters.addRange("price", adQuery.getInitialPrice(), adQuery.getFinalPrice());
        TimePeriod since = adQuery.getSince();
        if (since != null && since.isValid()) {
            Calendar sinceDate = since.remove(today);
            filters.addRange("publicationBegin", sinceDate, null);
        }
        filters.addPeriod("publicationBegin", adQuery.getPeriod());
        filters.addTerms("owner", adQuery.getOwner());
        filters.addTerms("owner.group", adQuery.getGroups());
        filters.addTerms("tradeType", adQuery.getTradeType());
        if (CollectionUtils.isNotEmpty(adQuery.getAdValues())) {
            for (AdCustomFieldValue adCustomFieldValue : adQuery.getAdValues()) {
                this.addCustomField(filters, analyzer, adCustomFieldValue);
            }
        }
        if (CollectionUtils.isNotEmpty(adQuery.getMemberValues())) {
            for (MemberCustomFieldValue memberCustomFieldValue : adQuery.getMemberValues()) {
                this.addCustomField(filters, analyzer, memberCustomFieldValue, "owner.customValues.%s");
            }
        }
        if (adQuery.isWithImagesOnly()) {
            filters.addTerms("hasImages", true);
        }
        if ((status = adQuery.getStatus()) != null) {
            Filter filter = Filters.terms("permanent", true);
            Filter isNotPermanent = Filters.terms("permanent", false);
            switch (status) {
                case PERMANENT: {
                    filters.add(filter);
                    break;
                }
                case ACTIVE: {
                    TermRangeFilter beginRange = Filters.range("publicationBegin", null, today);
                    TermRangeFilter endRange = Filters.range("publicationEnd", today, null);
                    filters.add(Filters.or(filter, Filters.and(new Filter[]{endRange, beginRange})));
                    break;
                }
                case SCHEDULED: {
                    TermRangeFilter beginRange = Filters.range("publicationBegin", today, null);
                    filters.add(Filters.and(new Filter[]{isNotPermanent, beginRange}));
                    break;
                }
                case EXPIRED: {
                    TermRangeFilter endRange = Filters.range("publicationEnd", null, today, false, false);
                    filters.add(Filters.and(new Filter[]{isNotPermanent, endRange}));
                }
            }
        }
        return new FullTextSearchElements((Query)query, filters, sort);
    }

    private static class FullTextSearchElements {
        private final Query query;
        private final Filters filters;
        private final Sort sort;

        public FullTextSearchElements(Query query, Filters filters, Sort sort) {
            this.query = query;
            this.filters = filters;
            this.sort = sort;
        }

        public Filters getFilters() {
            return this.filters;
        }

        public Query getQuery() {
            return this.query;
        }

        public Sort getSort() {
            return this.sort;
        }
    }
}

