/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.ads;

import java.util.Calendar;
import java.util.GregorianCalendar;
import nl.strohalm.cyclos.dao.members.MemberDocumentMapper;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.ads.AdCategory;
import nl.strohalm.cyclos.entities.customization.fields.AdCustomField;
import nl.strohalm.cyclos.entities.customization.fields.AdCustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomFieldValue;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.utils.StringHelper;
import nl.strohalm.cyclos.utils.lucene.AbstractDocumentMapper;
import nl.strohalm.cyclos.utils.lucene.DocumentBuilder;

public class AdDocumentMapper
extends AbstractDocumentMapper<Ad> {
    private static final Calendar PUBLICATION_BEGIN_WHEN_NULL = new GregorianCalendar(1900, 0, 1);
    private static final Calendar PUBLICATION_END_WHEN_NULL = new GregorianCalendar(2900, 0, 1);

    @Override
    protected DocumentBuilder newDocumentBuilder() {
        return new DocumentBuilder(this.fetchDao){

            @Override
            protected boolean includeInKeywordsSearch(String name, CustomFieldValue fieldValue) {
                if ("owner.customValues".equals(name)) {
                    return AdDocumentMapper.this.includeInKeywordsSearch((MemberCustomFieldValue)fieldValue);
                }
                return AdDocumentMapper.this.includeInKeywordsSearch((AdCustomFieldValue)fieldValue);
            }

            @Override
            protected boolean includeInSpecificFiltering(String name, CustomFieldValue fieldValue) {
                if ("owner.customValues".equals(name)) {
                    return AdDocumentMapper.this.includeInSpecificFiltering((MemberCustomFieldValue)fieldValue);
                }
                return AdDocumentMapper.this.includeInSpecificFiltering((AdCustomFieldValue)fieldValue);
            }
        };
    }

    @Override
    protected void process(DocumentBuilder document, Ad ad) {
        Calendar publicationEnd;
        Calendar publicationBegin;
        for (AdCategory category = ad.getCategory(); category != null; category = category.getParent()) {
            document.add("category", category);
        }
        String description = ad.getDescription();
        if (ad.isHtml()) {
            description = StringHelper.removeMarkupTagsAndUnescapeEntities(description);
        }
        boolean hasImages = ((Number)this.getSession().createFilter(ad.getImages(), "select count(*)").uniqueResult()).intValue() > 0;
        Calendar calendar = publicationBegin = ad.getPublicationPeriod() == null ? null : ad.getPublicationPeriod().getBegin();
        if (publicationBegin == null) {
            publicationBegin = PUBLICATION_BEGIN_WHEN_NULL;
        }
        Calendar calendar2 = publicationEnd = ad.getPublicationPeriod() == null ? null : ad.getPublicationPeriod().getEnd();
        if (publicationEnd == null) {
            publicationEnd = PUBLICATION_END_WHEN_NULL;
        }
        Calendar baseDate = publicationBegin == null ? ad.getCreationDate() : publicationBegin;
        Member owner = ad.getOwner();
        document.add("tradeType", ad.getTradeType());
        document.add("title", ad.getTitle());
        document.add("description", description);
        document.add("price", ad.getPrice());
        document.add("currency", ad.getCurrency());
        document.add("permanent", ad.isPermanent());
        document.add("baseDate", baseDate);
        document.add("externalPublication", ad.isExternalPublication());
        document.add("publicationBegin", publicationBegin);
        document.add("publicationEnd", publicationEnd);
        document.add("customValues", ad.getCustomValues());
        document.add("hasImages", hasImages);
        document.add("membersNotified", ad.isMembersNotified());
        document.add("owner", owner);
        document.add("owner.group", owner.getGroup());
        document.add("owner.name", owner.getName());
        document.add("owner.username", owner.getUsername());
        document.add("owner.customValues", owner.getCustomValues());
    }

    private boolean includeInKeywordsSearch(AdCustomFieldValue fieldValue) {
        AdCustomField field = (AdCustomField)fieldValue.getField();
        return field.isIndexed();
    }

    private boolean includeInKeywordsSearch(MemberCustomFieldValue fieldValue) {
        MemberCustomField field = (MemberCustomField)fieldValue.getField();
        return field.getIndexing() == MemberCustomField.Indexing.MEMBERS_AND_ADS && !fieldValue.isHidden();
    }

    private boolean includeInSpecificFiltering(AdCustomFieldValue fieldValue) {
        AdCustomField field = (AdCustomField)fieldValue.getField();
        return field.isShowInSearch();
    }

    private boolean includeInSpecificFiltering(MemberCustomFieldValue fieldValue) {
        MemberCustomField field = (MemberCustomField)fieldValue.getField();
        return MemberDocumentMapper.ACCESS_FOR_FILTERING.contains(field.getAdSearchAccess());
    }
}

