/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.ads.imports;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.ads.imports.ImportedAdCategoryDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.ads.AdCategory;
import nl.strohalm.cyclos.entities.ads.imports.AdImport;
import nl.strohalm.cyclos.entities.ads.imports.ImportedAdCategory;
import nl.strohalm.cyclos.utils.RelationshipHelper;

public class ImportedAdCategoryDAOImpl
extends BaseDAOImpl<ImportedAdCategory>
implements ImportedAdCategoryDAO {
    public ImportedAdCategoryDAOImpl() {
        super(ImportedAdCategory.class);
    }

    @Override
    public List<ImportedAdCategory> getLeafCategories(AdImport adImport) {
        String hql = "select c from " + this.getEntityType().getName() + " c where c.adImport.id = :id and not exists (select c1.id from " + this.getEntityType().getName() + " c1 where c1.importedParent = c)";
        List list = this.list(hql, adImport);
        ArrayList<ImportedAdCategory> categories = new ArrayList<ImportedAdCategory>(list.size());
        for (ImportedAdCategory category : list) {
            categories.add(this.fetchParent(category));
        }
        Collections.sort(categories, new Comparator<ImportedAdCategory>(){

            @Override
            public int compare(ImportedAdCategory cat1, ImportedAdCategory cat2) {
                return cat1.getFullName().compareTo(cat2.getFullName());
            }
        });
        return categories;
    }

    private ImportedAdCategory fetchParent(ImportedAdCategory category) {
        if (category.getExistingParent() != null) {
            category = this.getFetchDao().fetch(category, ImportedAdCategory.Relationships.EXISTING_PARENT);
            category.setExistingParent(this.getFetchDao().fetch(category.getExistingParent(), RelationshipHelper.nested(3, (Relationship)AdCategory.Relationships.PARENT)));
        } else if (category.getImportedParent() != null) {
            category = this.getFetchDao().fetch(category, ImportedAdCategory.Relationships.IMPORTED_PARENT);
            category.setImportedParent(this.fetchParent(category.getImportedParent()));
        }
        return category;
    }
}

