/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.alerts;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.alerts.AlertDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.alerts.Alert;
import nl.strohalm.cyclos.entities.alerts.AlertQuery;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;

public class AlertDAOImpl
extends BaseDAOImpl<Alert>
implements AlertDAO {
    public AlertDAOImpl() {
        super(Alert.class);
    }

    @Override
    public int delete(boolean flush, Long ... ids) {
        if (ids == null || ids.length == 0) {
            return 0;
        }
        String hql = "update " + this.getEntityType().getName() + " a set a.removed=true where a.id in (:ids)";
        Map<String, List<Long>> namedParameters = Collections.singletonMap("ids", Arrays.asList(ids));
        int results = this.bulkUpdate(hql.toString(), namedParameters);
        if (flush) {
            this.flush();
        }
        return results;
    }

    @Override
    public int getCount(Alert.Type type) {
        Integer count = (Integer)this.uniqueResult("select count(*) from " + type.getEntityType().getName() + " a where a.removed=false", null);
        return count;
    }

    @Override
    public List<Alert> search(AlertQuery query) {
        Class<Object> entityType = this.getEntityType();
        if (query.getMember() != null) {
            entityType = Alert.Type.MEMBER.getEntityType();
        } else if (query.getType() != null) {
            entityType = query.getType().getEntityType();
        }
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        Set<Relationship> fetch = query.getFetch();
        StringBuilder hql = HibernateHelper.getInitialQuery(entityType, "a", fetch);
        if (!query.isShowRemoved()) {
            hql.append(" and a.removed = false ");
        }
        if (entityType.equals(Alert.Type.MEMBER.getEntityType())) {
            HibernateHelper.addParameterToQuery(hql, namedParameters, "a.member", query.getMember());
            if (query.getGroups() != null && !query.getGroups().isEmpty()) {
                hql.append(" and a.member.group in (:groups) ");
                namedParameters.put("groups", query.getGroups());
            }
        }
        HibernateHelper.addParameterToQuery(hql, namedParameters, "a.key", query.getKey());
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "a.date", query.getPeriod());
        HibernateHelper.appendOrder(hql, "a.date desc, a.id desc");
        return this.list(query, hql.toString(), namedParameters);
    }
}

