/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.customizations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.customizations.CustomFieldDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberRecordCustomField;
import nl.strohalm.cyclos.entities.customization.fields.OperatorCustomField;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.records.MemberRecordType;
import nl.strohalm.cyclos.utils.DataIteratorHelper;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import org.hibernate.util.StringHelper;

public class CustomFieldDAOImpl
extends BaseDAOImpl<CustomField>
implements CustomFieldDAO {
    private static final String SEARCH_ACCESS = "searchAccess";
    private static final String LIST_ACCESS = "listAccess";

    public CustomFieldDAOImpl() {
        super(CustomField.class);
    }

    @Override
    public boolean isInternalNameUsed(CustomField field) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        namedParameters.put("_field_", field);
        StringBuilder hql = new StringBuilder("select count(*) from ");
        hql.append(field.getNature().getEntityType().getName());
        hql.append(" cf where " + (field.isPersistent() ? "cf <> :_field_" : "1=1"));
        switch (field.getNature()) {
            case OPERATOR: {
                HibernateHelper.addParameterToQuery(hql, namedParameters, "cf.member", ((OperatorCustomField)field).getMember());
                break;
            }
            case MEMBER_RECORD: {
                HibernateHelper.addParameterToQuery(hql, namedParameters, "cf.memberRecordType", ((MemberRecordCustomField)field).getMemberRecordType());
                break;
            }
        }
        HibernateHelper.addParameterToQuery(hql, namedParameters, "cf.internalName", field.getInternalName());
        Integer count = (Integer)this.uniqueResult(hql.toString(), namedParameters);
        return count > 0;
    }

    @Override
    public List<? extends CustomField> listByNature(CustomField.Nature nature, Relationship ... fetch) {
        StringBuilder hql = HibernateHelper.getInitialQuery(nature.getEntityType(), "f");
        HibernateHelper.appendOrder(hql, "f.order");
        return this.list(QueryParameters.ResultType.LIST, hql.toString(), null, null, fetch);
    }

    @Override
    public List<MemberRecordCustomField> listMemberRecordFields(MemberRecordType memberRecordType) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = HibernateHelper.getInitialQuery(MemberRecordCustomField.class, "f");
        HibernateHelper.addParameterToQuery(hql, namedParameters, "f.memberRecordType", memberRecordType);
        HibernateHelper.appendOrder(hql, "f.order");
        return this.list(QueryParameters.ResultType.LIST, hql.toString(), namedParameters, null, CustomField.Relationships.POSSIBLE_VALUES, CustomField.Relationships.CHILDREN);
    }

    @Override
    public List<OperatorCustomField> listOperatorFields(Member member) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = HibernateHelper.getInitialQuery(OperatorCustomField.class, "f");
        HibernateHelper.addParameterToQuery(hql, namedParameters, "f.member", member);
        HibernateHelper.appendOrder(hql, "f.order");
        return this.list(QueryParameters.ResultType.LIST, hql.toString(), namedParameters, null, CustomField.Relationships.POSSIBLE_VALUES, MemberCustomField.Relationships.GROUPS, CustomField.Relationships.CHILDREN);
    }

    @Override
    public List<PaymentCustomField> listPaymentFieldForList(Account account, boolean loan, Relationship ... fetch) {
        return this.listPaymentFieldsInternal(account, LIST_ACCESS, loan, fetch);
    }

    @Override
    public List<PaymentCustomField> listPaymentFieldForSearch(Account account, boolean loan, Relationship ... fetch) {
        return this.listPaymentFieldsInternal(account, SEARCH_ACCESS, loan, fetch);
    }

    @Override
    public List<PaymentCustomField> listPaymentFields(TransferType transferType, boolean includeDisabled, Relationship ... fetch) {
        HashMap<String, TransferType> namedParameters = new HashMap<String, TransferType>();
        namedParameters.put("transferType", transferType);
        StringBuilder hql = HibernateHelper.getInitialQuery(PaymentCustomField.class, "f", Arrays.asList(fetch));
        hql.append(" and (f.transferType = :transferType or exists (select tt.id from TransferType tt where tt = :transferType and f in elements(tt.linkedCustomFields)))");
        if (!includeDisabled) {
            hql.append(" and f.enabled = true");
        }
        HibernateHelper.appendOrder(hql, "case f.transferType.id when " + transferType.getId() + " then f.order else (999999999 * f.order) end");
        return this.list(QueryParameters.ResultType.LIST, hql.toString(), namedParameters, null, fetch);
    }

    @Override
    public PaymentCustomField loadPaymentFieldByInternalName(String internalName, Relationship[] fetch) {
        PaymentCustomField field = null;
        if (StringHelper.isNotEmpty((String)internalName)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            StringBuilder hql = HibernateHelper.getInitialQuery(PaymentCustomField.class, "f", Arrays.asList(fetch));
            HibernateHelper.addParameterToQuery(hql, params, "name", internalName);
            field = (PaymentCustomField)this.uniqueResult(hql.toString(), params);
        }
        if (field == null) {
            throw new EntityNotFoundException(PaymentCustomField.class);
        }
        return this.getFetchDao().fetch(field, fetch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PaymentCustomField> listPaymentFieldsInternal(Account account, String accessProperty, boolean loan, Relationship ... fetch) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        namedParameters.put("accountType", account.getType());
        AccountOwner owner = account.getOwner();
        if (owner instanceof Member) {
            namedParameters.put("ownerMember", owner);
        }
        for (PaymentCustomField.Access access : PaymentCustomField.Access.values()) {
            namedParameters.put(access.name(), access);
        }
        StringBuilder hql = new StringBuilder("select DISTINCT f, f.transferType.name from ");
        hql.append(PaymentCustomField.class.getName());
        hql.append(" f left join f.linkedTransferTypes as linkedTransferType");
        hql.append(" where (");
        hql.append(" (f." + accessProperty + " = :FROM_ACCOUNT and (f.transferType.from = :accountType or linkedTransferType.from = :accountType))");
        hql.append(" or (f." + accessProperty + " = :TO_ACCOUNT and (f.transferType.to = :accountType or linkedTransferType.to = :accountType))");
        hql.append(" or (f." + accessProperty + " = :BOTH_ACCOUNTS and (f.transferType.from = :accountType or linkedTransferType.from = :accountType or f.transferType.to = :accountType or linkedTransferType.to = :accountType))");
        hql.append(" or (f." + accessProperty + " = :DESTINATION_MEMBER and f.transferType.fixedDestinationMember = :ownerMember)");
        hql.append(" ) ");
        hql.append(" and f.transferType.loan.type is " + (loan ? "not null" : "null"));
        HibernateHelper.appendOrder(hql, "f.transferType.name", "f.order");
        Iterator iterator = this.iterate(hql.toString(), namedParameters);
        try {
            ArrayList<PaymentCustomField> results = new ArrayList<PaymentCustomField>();
            while (iterator.hasNext()) {
                results.add((PaymentCustomField)((Object[])iterator.next())[0]);
            }
            ArrayList<PaymentCustomField> arrayList = results;
            return arrayList;
        }
        finally {
            DataIteratorHelper.close(iterator);
        }
    }
}

