/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.customizations;

import java.io.Serializable;
import java.util.HashMap;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.customizations.CustomFieldPossibleValueDAO;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldPossibleValue;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;

public class CustomFieldPossibleValueDAOImpl
extends BaseDAOImpl<CustomFieldPossibleValue>
implements CustomFieldPossibleValueDAO {
    public CustomFieldPossibleValueDAOImpl() {
        super(CustomFieldPossibleValue.class);
    }

    @Override
    public void ensureDefault(CustomFieldPossibleValue possibleValue) {
        if (possibleValue.isDefaultValue()) {
            HashMap<String, Serializable> namedParameters = new HashMap<String, Serializable>();
            StringBuilder hql = new StringBuilder();
            hql.append("update ").append(CustomFieldPossibleValue.class.getName());
            hql.append(" set defaultValue = false");
            hql.append(" where field = :field");
            hql.append("   and id <> :id");
            namedParameters.put("field", possibleValue.getField());
            namedParameters.put("id", possibleValue.getId());
            if (possibleValue.getParent() != null) {
                hql.append(" and parent = :parent");
                namedParameters.put("parent", possibleValue.getParent());
            }
            this.bulkUpdate(hql.toString(), namedParameters);
        }
    }

    @Override
    public CustomFieldPossibleValue load(Long fieldId, String value) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("fieldId", fieldId);
        params.put("value", value);
        CustomFieldPossibleValue possibleValue = (CustomFieldPossibleValue)this.uniqueResult("from " + CustomFieldPossibleValue.class.getName() + " pv where pv.field.id = :fieldId and pv.value = :value", params);
        if (possibleValue == null) {
            throw new EntityNotFoundException(this.getEntityType());
        }
        return possibleValue;
    }
}

