/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.customizations;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.customizations.CustomizedFileDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.files.CustomizedFile;
import nl.strohalm.cyclos.entities.customization.files.CustomizedFileQuery;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;

public class CustomizedFileDAOImpl
extends BaseDAOImpl<CustomizedFile>
implements CustomizedFileDAO {
    public CustomizedFileDAOImpl() {
        super(CustomizedFile.class);
    }

    @Override
    public CustomizedFile load(CustomizedFile.Type type, String name, Relationship ... fetch) throws DaoException {
        StringBuilder hql = HibernateHelper.getInitialQuery(this.getEntityType(), "f", fetch == null ? null : Arrays.asList(fetch));
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        HibernateHelper.addParameterToQuery(hql, namedParameters, "f.type", type);
        HibernateHelper.addParameterToQuery(hql, namedParameters, "f.name", name);
        hql.append(" and f.group is null and f.groupFilter is null");
        CustomizedFile file = (CustomizedFile)this.uniqueResult(hql.toString(), namedParameters);
        if (file == null) {
            throw new EntityNotFoundException(CustomizedFile.class);
        }
        return file;
    }

    @Override
    public List<CustomizedFile> search(CustomizedFileQuery query) {
        StringBuilder hql = HibernateHelper.getInitialQuery(this.getEntityType(), "f", query.getFetch());
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        if (!query.isAll()) {
            HibernateHelper.addParameterToQuery(hql, namedParameters, "f.type", query.getType());
            Group group = query.getGroup();
            if (group == null) {
                hql.append(" and f.group is null");
            } else {
                HibernateHelper.addParameterToQuery(hql, namedParameters, "f.group", group);
            }
            GroupFilter groupFilter = query.getGroupFilter();
            if (groupFilter == null) {
                hql.append(" and f.groupFilter is null");
            } else {
                HibernateHelper.addParameterToQuery(hql, namedParameters, "f.groupFilter", groupFilter);
            }
        }
        HibernateHelper.appendOrder(hql, "f.type", "f.name");
        return this.list(query, hql.toString(), namedParameters);
    }
}

