/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.customizations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.customizations.DocumentDAO;
import nl.strohalm.cyclos.entities.customization.documents.Document;
import nl.strohalm.cyclos.entities.customization.documents.DocumentQuery;
import nl.strohalm.cyclos.entities.customization.documents.MemberDocument;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;

public class DocumentDAOImpl
extends BaseDAOImpl<Document>
implements DocumentDAO {
    public DocumentDAOImpl() {
        super(Document.class);
    }

    @Override
    public List<Document> search(DocumentQuery query) throws DaoException {
        Member member;
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = HibernateHelper.getInitialQuery(this.getEntityType(), "doc", query.getFetch());
        namedParameters.put("dynamicType", Document.Nature.DYNAMIC.getValue());
        namedParameters.put("memberType", Document.Nature.MEMBER.getValue());
        namedParameters.put("staticType", Document.Nature.STATIC.getValue());
        namedParameters.put("memberVisibility", MemberDocument.Visibility.MEMBER.getValue());
        namedParameters.put("brokerVisibility", MemberDocument.Visibility.BROKER.getValue());
        if (query.getId() != null) {
            HibernateHelper.addParameterToQuery(hql, namedParameters, "doc.id", query.getId());
        }
        if (query.getNatures() != null) {
            hql.append(" and doc.class in (:natures) ");
            Collection<Document.Nature> natures = query.getNatures();
            ArrayList<String> natureValues = new ArrayList<String>();
            for (Document.Nature nature : natures) {
                natureValues.add(nature.getValue());
            }
            namedParameters.put("natures", natureValues);
        }
        boolean searchingForABrokeredMemberDocuments = false;
        Element viewer = query.getViewer();
        if (viewer != null) {
            viewer = this.getFetchDao().fetch(viewer, Element.Relationships.GROUP);
            if (query.getMember() != null && LoggedUser.isBroker() && viewer.equals((member = this.getFetchDao().fetch(query.getMember(), Member.Relationships.BROKER)).getBroker())) {
                searchingForABrokeredMemberDocuments = true;
                hql.append(" and ( ");
                if (query.isBrokerCanViewMemberDocuments()) {
                    hql.append(" (doc.class = :memberType) or ");
                }
                hql.append(" exists (select g.id from BrokerGroup g where doc in elements(g.brokerDocuments) and g = :group)) ");
            }
            if (!searchingForABrokeredMemberDocuments) {
                hql.append(" and (doc.class = :memberType or exists (select g.id from Group g where doc in elements(g.documents) and g = :group)) ");
            }
            namedParameters.put("group", viewer.getGroup());
        }
        if (query.getMember() != null) {
            member = this.getFetchDao().fetch(query.getMember(), Member.Relationships.BROKER);
            hql.append(" and (doc.class in (:dynamicType, :staticType) or ");
            hql.append(" exists (select id from MemberDocument md where md = doc and md.member = :member and md.member.group in (:groups) ");
            namedParameters.put("groups", query.getVisibleGroups());
            if (viewer instanceof Member) {
                if (viewer.equals(member)) {
                    hql.append(" and md.visibility = :memberVisibility ");
                }
                if (member.getBroker() != null && member.getBroker().equals(viewer)) {
                    hql.append(" and md.visibility in (:memberVisibility, :brokerVisibility) ");
                }
            }
            hql.append(" )) ");
            namedParameters.put("member", query.getMember());
        }
        HibernateHelper.appendOrder(hql, "doc.name");
        return this.list(query, hql.toString(), namedParameters);
    }
}

