/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.customizations;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.customizations.ImageDAO;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.customization.images.Image;
import nl.strohalm.cyclos.entities.customization.images.OwneredImage;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.members.Member;

public class ImageDAOImpl
extends BaseDAOImpl<Image>
implements ImageDAO {
    public ImageDAOImpl() {
        super(Image.class);
    }

    @Override
    public int countAdImages(Ad ad) {
        return (Integer)this.uniqueResult("select count(*) from AdImage i where i.ad.id = :id", ad);
    }

    @Override
    public int countMemberImages(Member member) {
        return (Integer)this.uniqueResult("select count(*) from MemberImage i where i.member.id = :id", member);
    }

    @Override
    public List<? extends Image> listByNature(Image.Nature nature) throws DaoException {
        this.checkNature(nature);
        return this.list("from " + nature.getEntityType().getName() + " i order by i.name", null);
    }

    @Override
    public List<? extends OwneredImage> listByOwner(Entity owner) {
        Image.Nature nature = Image.Nature.getByOwner(owner);
        if (nature == null) {
            throw new UnexpectedEntityException();
        }
        Map<String, Entity> params = Collections.singletonMap("owner", owner);
        return this.list("from " + nature.getEntityType().getName() + " i where i." + nature.getOwnerProperty() + " = :owner order by i.order", params);
    }

    @Override
    public Image load(Image.Nature nature, String name) {
        this.checkNature(nature);
        Map<String, String> params = Collections.singletonMap("name", name);
        Image image = (Image)this.uniqueResult("from " + nature.getEntityType().getName() + " i where i.name = :name", params);
        if (image == null) {
            throw new EntityNotFoundException(this.getEntityType());
        }
        return image;
    }

    private void checkNature(Image.Nature nature) {
        if (nature == null || nature == Image.Nature.MEMBER || nature == Image.Nature.AD) {
            throw new IllegalArgumentException("Invalid nature: " + nature);
        }
    }
}

