/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.customizations;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.customizations.TranslationMessageDAO;
import nl.strohalm.cyclos.entities.customization.translationMessages.TranslationMessage;
import nl.strohalm.cyclos.entities.customization.translationMessages.TranslationMessageQuery;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.utils.DataIteratorHelper;
import nl.strohalm.cyclos.utils.SortedProperties;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import org.apache.commons.lang.StringUtils;

public class TranslationMessageDAOImpl
extends BaseDAOImpl<TranslationMessage>
implements TranslationMessageDAO {
    public TranslationMessageDAOImpl() {
        super(TranslationMessage.class);
    }

    @Override
    public int deleteAll() {
        return this.getHibernateTemplate().bulkUpdate("delete from " + this.getEntityType().getName());
    }

    @Override
    public Iterator<String> listAllKeys() throws DaoException {
        return this.iterate("select m.key from " + this.getEntityType().getName() + " m", null);
    }

    @Override
    public Properties listAsProperties() {
        SortedProperties properties = new SortedProperties();
        Iterator iterator = this.iterate("select m.key, m.value from " + this.getEntityType().getName() + " m", null);
        while (iterator.hasNext()) {
            Object[] row = (Object[])iterator.next();
            String key = StringUtils.trimToEmpty((String)((String)row[0]));
            String value = StringUtils.trimToEmpty((String)((String)row[1]));
            properties.setProperty(key, value);
        }
        DataIteratorHelper.close(iterator);
        return properties;
    }

    @Override
    public Iterator<Object[]> listData() throws DaoException {
        return this.iterate("select m.id, m.key, m.value from " + this.getEntityType().getName() + " m", null);
    }

    @Override
    public TranslationMessage load(String key) {
        Map<String, String> params = Collections.singletonMap("key", key);
        TranslationMessage translationMessage = (TranslationMessage)this.uniqueResult("from " + this.getEntityType().getName() + " e where e.key = :key", params);
        if (translationMessage == null) {
            throw new EntityNotFoundException(this.getEntityType());
        }
        return translationMessage;
    }

    @Override
    public List<TranslationMessage> search(TranslationMessageQuery query) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = HibernateHelper.getInitialQuery(this.getEntityType(), "m");
        HibernateHelper.addLikeParameterToQuery(hql, namedParameters, "m.key", query.getKey());
        HibernateHelper.addLikeParameterToQuery(hql, namedParameters, "m.value", query.getValue());
        if (query.isShowOnlyEmpty()) {
            hql.append(" and (m.value is null or length(m.value) = 0)");
        }
        HibernateHelper.appendOrder(hql, "m.key");
        return this.list(query, hql.toString(), namedParameters);
    }
}

