/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.groups;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.groups.GroupDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.MemberGroupAccountSettings;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.groups.OperatorGroup;
import nl.strohalm.cyclos.entities.groups.SystemGroup;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import org.apache.commons.collections.CollectionUtils;

public class GroupDAOImpl
extends BaseDAOImpl<Group>
implements GroupDAO {
    public GroupDAOImpl() {
        super(Group.class);
    }

    @Override
    public int delete(boolean flush, Long ... ids) {
        boolean count = false;
        for (Long id : ids) {
            try {
                Group group = (Group)this.load(id, MemberGroup.Relationships.CAN_VIEW_PROFILE_OF_GROUPS, MemberGroup.Relationships.CAN_VIEW_ADS_OF_GROUPS, MemberGroup.Relationships.POSSIBLE_INITIAL_GROUP_OF);
                if (group instanceof MemberGroup) {
                    MemberGroup memberGroup = (MemberGroup)group;
                    List otherGroups = this.list("from MemberGroup g where g.id <> :id", memberGroup);
                    for (MemberGroup other : otherGroups) {
                        while (other.getCanViewProfileOfGroups().remove(memberGroup)) {
                        }
                        while (other.getCanViewAdsOfGroups().remove(memberGroup)) {
                        }
                    }
                    for (BrokerGroup brokerGroup : memberGroup.getPossibleInitialGroupOf()) {
                        brokerGroup.getPossibleInitialGroups().remove(memberGroup);
                    }
                }
                for (GroupFilter groupFilter : this.list("from " + GroupFilter.class.getName(), null)) {
                    groupFilter.getGroups().remove(group);
                    groupFilter.getViewableBy().remove(group);
                }
                this.getHibernateTemplate().delete((Object)group);
            }
            catch (EntityNotFoundException e) {
                // empty catch block
            }
        }
        this.getHibernateTemplate().flush();
        return 0;
    }

    @Override
    public SystemGroup findByLoginPageName(String loginPageName) {
        SystemGroup group = (SystemGroup)this.uniqueResult("from SystemGroup g where g.loginPageName = :name", Collections.singletonMap("name", loginPageName));
        if (group == null) {
            throw new EntityNotFoundException(SystemGroup.class);
        }
        return group;
    }

    @Override
    public Map<String, Integer> getGroupMemberCount() {
        List list = this.list("select g.name, count(e.id) from MemberGroup g left join g.elements e group by g.class, g.name order by g.class desc, g.name", null);
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        for (Object[] row : list) {
            map.put((String)row[0], (Integer)row[1]);
        }
        return map;
    }

    @Override
    public List<OperatorGroup> iterateOperatorGroups(MemberGroup memberGroup) {
        if (memberGroup == null) {
            return Collections.emptyList();
        }
        String hql = "from OperatorGroup g where g.member.group = :group";
        Map<String, MemberGroup> params = Collections.singletonMap("group", memberGroup);
        return this.list(QueryParameters.ResultType.ITERATOR, "from OperatorGroup g where g.member.group = :group", params, null, new Relationship[0]);
    }

    @Override
    public List<MemberGroup> listActiveMemberGroups() {
        StringBuilder hql = new StringBuilder();
        hql.append("from MemberGroup where size(accountSettings)>0");
        return this.list(hql.toString(), new HashMap());
    }

    @Override
    public List<? extends Group> search(GroupQuery query) throws DaoException {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = HibernateHelper.getInitialQuery(this.getEntityType(), "g", query.getFetch());
        HibernateHelper.addInParameterToQuery(hql, namedParameters, "g", query.getPossibleGroups());
        HibernateHelper.addInParameterToQuery(hql, namedParameters, "g.class", query.getNatureDiscriminators());
        HibernateHelper.addInParameterToQuery(hql, namedParameters, "g.status", query.getStatusCollection());
        if (query.isOnlyActive()) {
            hql.append(" and exists (select mg.id from MemberGroup mg where mg = g and mg.active = true) ");
        }
        if (CollectionUtils.isNotEmpty(query.getGroupFilters())) {
            HashSet<MemberGroup> groups = new HashSet<MemberGroup>();
            for (GroupFilter groupFilter : query.getGroupFilters()) {
                groupFilter = this.getFetchDao().fetch(groupFilter, GroupFilter.Relationships.GROUPS);
                groups.addAll(groupFilter.getGroups());
            }
            if (CollectionUtils.isNotEmpty(groups)) {
                hql.append(" and g in (:groups) ");
                namedParameters.put("groups", groups);
            }
        }
        if (query.getBroker() != null) {
            hql.append("and exists (select mg.id from MemberGroup mg, Member m where mg = g and m.group = mg and m.broker = :broker) ");
            namedParameters.put("broker", query.getBroker());
        }
        if (query.getMember() != null) {
            hql.append("and exists (select og.id from OperatorGroup og where og = g and og.member = :member) ");
            namedParameters.put("member", query.getMember());
        }
        if (query.getMemberAccountType() != null) {
            hql.append(" and exists (select s.id from " + MemberGroupAccountSettings.class.getName() + " s where s.accountType = :accountType and s.group = g) ");
            namedParameters.put("accountType", query.getMemberAccountType());
        }
        HibernateHelper.addInElementsParameter(hql, namedParameters, "g.paymentFilters", query.getPaymentFilter());
        if (query.getManagedBy() != null) {
            hql.append(" and ((g.class = :adminGroup) or (g in (select mg from AdminGroup ag join ag.managesGroups mg where ag = :managedBy))) ");
            namedParameters.put("adminGroup", Group.Nature.ADMIN.getDiscriminator());
            namedParameters.put("managedBy", query.getManagedBy());
        }
        ArrayList<String> order = new ArrayList<String>();
        if (query.isSortByNature()) {
            order.add("case g.class when 'A' then 1 when 'M' then 2 else 3 end");
        }
        order.add("g.name");
        HibernateHelper.appendOrder(hql, order.toArray(new String[order.size()]));
        return this.list(query, hql.toString(), namedParameters);
    }
}

