/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.groups;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.groups.GroupFilterDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.entities.groups.GroupFilterQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import org.apache.commons.collections.CollectionUtils;

public class GroupFilterDAOImpl
extends BaseDAOImpl<GroupFilter>
implements GroupFilterDAO {
    public GroupFilterDAOImpl() {
        super(GroupFilter.class);
    }

    @Override
    public GroupFilter findByLoginPageName(String loginPageName) {
        GroupFilter groupFilter = (GroupFilter)this.uniqueResult("from GroupFilter gf where gf.loginPageName = :name", Collections.singletonMap("name", loginPageName));
        if (groupFilter == null) {
            throw new EntityNotFoundException(Group.class);
        }
        return groupFilter;
    }

    @Override
    public List<GroupFilter> search(GroupFilterQuery query) throws DaoException {
        AdminGroup adminGroup;
        Collection<MemberGroup> adminManagedGroups;
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        Set<Relationship> fetch = query.getFetch();
        StringBuilder hql = HibernateHelper.getInitialQuery(this.getEntityType(), "gf", fetch);
        HibernateHelper.addLikeParameterToQuery(hql, namedParameters, "gf.description", query.getDescription());
        HibernateHelper.addLikeParameterToQuery(hql, namedParameters, "gf.name", query.getName());
        if (query.getGroup() != null) {
            hql.append(" and :group in elements(gf.groups) ");
            namedParameters.put("group", query.getGroup());
        }
        if (query.getViewableBy() != null) {
            hql.append(" and :viewerGroup in elements(gf.viewableBy) ");
            namedParameters.put("viewerGroup", query.getViewableBy());
        }
        if (query.getAdminGroup() != null && CollectionUtils.isNotEmpty(adminManagedGroups = (adminGroup = this.getFetchDao().fetch(query.getAdminGroup(), AdminGroup.Relationships.MANAGES_GROUPS)).getManagesGroups())) {
            hql.append(" and exists (select g.id from Group g where g in elements(gf.groups) and g in (:adminManagedGroups)) ");
            namedParameters.put("adminManagedGroups", adminManagedGroups);
        }
        HibernateHelper.appendOrder(hql, "gf.name");
        return this.list(query, hql.toString(), namedParameters);
    }
}

