/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.infotexts;

import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.infotexts.InfoTextDAO;
import nl.strohalm.cyclos.entities.infotexts.InfoText;
import nl.strohalm.cyclos.entities.infotexts.InfoTextQuery;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import org.apache.commons.lang.StringUtils;

public class InfoTextDAOImpl
extends BaseDAOImpl<InfoText>
implements InfoTextDAO {
    public InfoTextDAOImpl() {
        super(InfoText.class);
    }

    @Override
    public List<InfoText> search(InfoTextQuery query) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = HibernateHelper.getInitialQuery(InfoText.class, "info", query.getFetch());
        String alias = StringUtils.trimToNull((String)query.getAlias());
        if (alias != null) {
            hql.append(" and :alias in elements(info.aliases) ");
            namedParameters.put("alias", alias);
        }
        if (query.getKeywords() != null) {
            hql.append(" and (info.subject like :keywords or info.body like :keywords) ");
            namedParameters.put("keywords", "%" + query.getKeywords().toUpperCase() + "%");
        }
        if (query.isWithBodyOnly()) {
            hql.append(" and length(info.body) > 0");
        }
        if (query.isOnlyActive()) {
            HibernateHelper.QueryParameter endParameter;
            HibernateHelper.addParameterToQuery(hql, namedParameters, "info.enabled", Boolean.TRUE);
            Period period = Period.day(Calendar.getInstance());
            HibernateHelper.QueryParameter beginParameter = HibernateHelper.getBeginParameter(period);
            if (beginParameter != null) {
                hql.append(" and (info.validity.end is null or info.validity.end " + beginParameter.getOperator() + " :_begin_)");
                namedParameters.put("_begin_", beginParameter.getValue());
            }
            if ((endParameter = HibernateHelper.getEndParameter(period)) != null) {
                hql.append(" and (info.validity.begin is null or info.validity.begin " + endParameter.getOperator() + " :_end_)");
                namedParameters.put("_end_", endParameter.getValue());
            }
        } else {
            HibernateHelper.addParameterToQuery(hql, namedParameters, "info.enabled", query.getEnabled());
            HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "info.validity.begin", query.getStartIn());
            HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "info.validity.end", query.getEndIn());
        }
        return this.list(query, hql.toString(), namedParameters);
    }
}

